/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.widget;

import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.drawable.ITextLine;
import brachy.modularui.screen.RichTooltip;
import brachy.modularui.utils.Alignment;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ITooltip<W extends ITooltip<W>> {
    @Nullable
    public RichTooltip getTooltip();

    @NotNull
    public RichTooltip tooltip();

    public W tooltip(RichTooltip var1);

    default public boolean hasTooltip() {
        return this.getTooltip() != null && !this.getTooltip().isEmpty();
    }

    default public W getThis() {
        return (W)this;
    }

    default public W tooltip(Consumer<RichTooltip> tooltipConsumer) {
        return this.tooltipStatic(tooltipConsumer);
    }

    default public W tooltipStatic(Consumer<RichTooltip> tooltipConsumer) {
        tooltipConsumer.accept(this.tooltip());
        return this.getThis();
    }

    default public W tooltipBuilder(Consumer<RichTooltip> tooltipBuilder) {
        return this.tooltipDynamic(tooltipBuilder);
    }

    default public W tooltipDynamic(Consumer<RichTooltip> tooltipBuilder) {
        this.tooltip().tooltipBuilder(tooltipBuilder);
        return this.getThis();
    }

    default public W tooltipPos(RichTooltip.Pos pos) {
        this.tooltip().pos(pos);
        return this.getThis();
    }

    default public W tooltipPos(int x, int y) {
        this.tooltip().pos(x, y);
        return this.getThis();
    }

    default public W tooltipAlignment(Alignment alignment) {
        this.tooltip().alignment(alignment);
        return this.getThis();
    }

    default public W tooltipTextShadow(boolean textShadow) {
        this.tooltip().textShadow(textShadow);
        return this.getThis();
    }

    default public W tooltipTextColor(int textColor) {
        this.tooltip().textColor(textColor);
        return this.getThis();
    }

    default public W tooltipScale(float scale) {
        this.tooltip().scale(scale);
        return this.getThis();
    }

    default public W tooltipShowUpTimer(int showUpTimer) {
        this.tooltip().showUpTimer(showUpTimer);
        return this.getThis();
    }

    default public W tooltipAutoUpdate(boolean update) {
        this.tooltip().autoUpdate(update);
        return this.getThis();
    }

    default public W tooltipHasTitleMargin(boolean hasTitleMargin) {
        return this.getThis();
    }

    default public W tooltipLinePadding(int linePadding) {
        return this.getThis();
    }

    default public W addTooltipElement(String s) {
        this.tooltip().add(s);
        return this.getThis();
    }

    default public W addTooltipElement(IDrawable drawable) {
        this.tooltip().add(drawable);
        return this.getThis();
    }

    default public W addTooltipLine(ITextLine line) {
        this.tooltip().addLine(line);
        return this.getThis();
    }

    default public W addTooltipLine(IDrawable drawable) {
        ((RichTooltip)this.tooltip().add(drawable)).newLine();
        return this.getThis();
    }

    default public W addTooltipLine(String line) {
        return this.addTooltipLine(IKey.str(line));
    }

    default public W addTooltipDrawableLines(Iterable<IDrawable> lines) {
        this.tooltip().addDrawableLines(lines);
        return this.getThis();
    }

    default public W addTooltipStringLines(Iterable<String> lines) {
        this.tooltip().addStringLines(lines);
        return this.getThis();
    }

    default public W removeAllTooltips() {
        this.tooltip().reset();
        return this.getThis();
    }
}

