/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.widget;

import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.api.widget.ResizeDragArea;
import brachy.modularui.widget.sizer.Area;

public interface IDragResizeable {
    default public boolean isCurrentlyResizable() {
        return true;
    }

    default public boolean keepPosOnDragResize() {
        return true;
    }

    default public void onDragResize() {
        ((IWidget)((Object)this)).scheduleResize();
    }

    default public int getDragAreaSize() {
        return 3;
    }

    default public int getMinDragWidth() {
        return 18;
    }

    default public int getMinDragHeight() {
        return 18;
    }

    public static ResizeDragArea getDragResizeCorner(IDragResizeable widget, Area area, IViewportStack stack, int x, int y) {
        if (!widget.isCurrentlyResizable()) {
            return null;
        }
        int mx = stack.unTransformX(x, y);
        int my = stack.unTransformY(x, y);
        if (mx < 0 || my < 0 || mx > area.w() || my > area.h()) {
            return null;
        }
        int ras = widget.getDragAreaSize();
        if (mx < ras) {
            if (my < ras) {
                return ResizeDragArea.TOP_LEFT;
            }
            if (my > area.h() - ras) {
                return ResizeDragArea.BOTTOM_LEFT;
            }
            return ResizeDragArea.LEFT;
        }
        if (mx > area.w() - ras) {
            if (my < ras) {
                return ResizeDragArea.TOP_RIGHT;
            }
            if (my > area.h() - ras) {
                return ResizeDragArea.BOTTOM_RIGHT;
            }
            return ResizeDragArea.RIGHT;
        }
        if (my < ras) {
            return ResizeDragArea.TOP;
        }
        if (my > area.h() - ras) {
            return ResizeDragArea.BOTTOM;
        }
        return null;
    }

    public static void applyDrag(IDragResizeable resizeable, IWidget widget, ResizeDragArea dragArea, Area startArea, int dx, int dy) {
        int s;
        int keepPosFactor;
        int n = keepPosFactor = resizeable.keepPosOnDragResize() || Interactable.hasShiftDown() ? 2 : 1;
        if (dx != 0) {
            if (dragArea.left) {
                s = startArea.width - dx * keepPosFactor;
                if (s >= resizeable.getMinDragWidth()) {
                    widget.resizer().left(startArea.rx + dx);
                    widget.resizer().width(s);
                }
            } else if (dragArea.right && (s = startArea.width + dx * keepPosFactor) >= resizeable.getMinDragWidth()) {
                widget.resizer().left(startArea.rx - dx * (keepPosFactor - 1));
                widget.resizer().width(s);
            }
        }
        if (dy != 0) {
            if (dragArea.top) {
                s = startArea.height - dy * keepPosFactor;
                if (s >= resizeable.getMinDragHeight()) {
                    widget.resizer().top(startArea.ry + dy);
                    widget.resizer().height(s);
                }
            } else if (dragArea.bottom && (s = startArea.height + dy * keepPosFactor) >= resizeable.getMinDragHeight()) {
                widget.resizer().top(startArea.ry - dy * (keepPosFactor - 1));
                widget.resizer().height(s);
            }
        }
        resizeable.onDragResize();
    }
}

