/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.drawable;

import brachy.modularui.api.IJsonSerializable;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.text.AnimatedText;
import brachy.modularui.drawable.text.CompoundKey;
import brachy.modularui.drawable.text.DynamicKey;
import brachy.modularui.drawable.text.FormattingState;
import brachy.modularui.drawable.text.KeyIcon;
import brachy.modularui.drawable.text.LangKey;
import brachy.modularui.drawable.text.StringKey;
import brachy.modularui.drawable.text.StyledText;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.serialization.json.JsonHelper;
import brachy.modularui.widgets.TextWidget;
import com.google.gson.JsonObject;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IKey
extends IDrawable,
IJsonSerializable<IKey> {
    public static final int TEXT_COLOR = -12566464;
    public static final TextRenderer renderer = new TextRenderer();
    public static final IKey EMPTY = IKey.str("");
    public static final IKey LINE_FEED = IKey.str("\n");
    public static final IKey SPACE = IKey.str(" ");
    public static final ChatFormatting BLACK = ChatFormatting.BLACK;
    public static final ChatFormatting DARK_BLUE = ChatFormatting.DARK_BLUE;
    public static final ChatFormatting DARK_GREEN = ChatFormatting.DARK_GREEN;
    public static final ChatFormatting DARK_AQUA = ChatFormatting.DARK_AQUA;
    public static final ChatFormatting DARK_RED = ChatFormatting.DARK_RED;
    public static final ChatFormatting DARK_PURPLE = ChatFormatting.DARK_PURPLE;
    public static final ChatFormatting GOLD = ChatFormatting.GOLD;
    public static final ChatFormatting GRAY = ChatFormatting.GRAY;
    public static final ChatFormatting DARK_GRAY = ChatFormatting.DARK_GRAY;
    public static final ChatFormatting BLUE = ChatFormatting.BLUE;
    public static final ChatFormatting GREEN = ChatFormatting.GREEN;
    public static final ChatFormatting AQUA = ChatFormatting.AQUA;
    public static final ChatFormatting RED = ChatFormatting.RED;
    public static final ChatFormatting LIGHT_PURPLE = ChatFormatting.LIGHT_PURPLE;
    public static final ChatFormatting YELLOW = ChatFormatting.YELLOW;
    public static final ChatFormatting WHITE = ChatFormatting.WHITE;
    public static final ChatFormatting OBFUSCATED = ChatFormatting.OBFUSCATED;
    public static final ChatFormatting BOLD = ChatFormatting.BOLD;
    public static final ChatFormatting STRIKETHROUGH = ChatFormatting.STRIKETHROUGH;
    public static final ChatFormatting UNDERLINE = ChatFormatting.UNDERLINE;
    public static final ChatFormatting ITALIC = ChatFormatting.ITALIC;
    public static final ChatFormatting RESET = ChatFormatting.RESET;

    public static IKey lang(@NotNull String key) {
        return new LangKey(key);
    }

    public static IKey lang(@NotNull Component component) {
        return new LangKey(component);
    }

    public static IKey lang(@NotNull String key, Object ... args) {
        return new LangKey(key, args);
    }

    public static IKey lang(@NotNull String key, @NotNull Supplier<Object[]> argsSupplier) {
        return new LangKey(key, argsSupplier);
    }

    public static IKey lang(@NotNull Supplier<String> keySupplier) {
        return new LangKey(keySupplier);
    }

    public static IKey lang(@NotNull Supplier<String> keySupplier, @NotNull Supplier<Object[]> argsSupplier) {
        return new LangKey(keySupplier, argsSupplier);
    }

    public static IKey str(@NotNull String key) {
        return new StringKey(key);
    }

    public static IKey str(@NotNull String key, Object ... args) {
        return new StringKey(key, args);
    }

    public static IKey comp(IKey ... keys) {
        return new CompoundKey(keys);
    }

    public static IKey dynamic(@NotNull @NotNull Supplier<@NotNull Component> supp) {
        if (supp.get() instanceof MutableComponent) {
            return IKey.dynamicKey(() -> IKey.lang((Component)supp.get()));
        }
        return IKey.dynamicKey(() -> IKey.lang((Component)((Component)supp.get()).m_6881_()));
    }

    public static IKey dynamicKey(@NotNull @NotNull Supplier<@NotNull IKey> supp) {
        return new DynamicKey(supp);
    }

    public MutableComponent get();

    default public MutableComponent getFormatted(@Nullable FormattingState parentFormatting) {
        return this.get();
    }

    default public MutableComponent getFormatted() {
        return this.getFormatted(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        this.drawAligned(context, x, y, width, height, widgetTheme, Alignment.CENTER);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void drawAligned(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme, Alignment alignment) {
        renderer.setColor(widgetTheme.getTextColor());
        renderer.setShadow(widgetTheme.isTextShadow());
        renderer.setAlignment(alignment, width, height);
        renderer.setScale(this.getScale());
        renderer.setPos(x, y);
        renderer.draw(context.getGraphics(), (Component)this.getFormatted());
    }

    @Override
    default public boolean canApplyTheme() {
        return true;
    }

    @Override
    default public int getDefaultWidth() {
        renderer.setAlignment(Alignment.TopLeft, -1.0f, -1.0f);
        renderer.setScale(this.getScale());
        renderer.setPos(0, 0);
        renderer.setSimulate(true);
        renderer.draw(null, (Component)this.getFormatted());
        renderer.setSimulate(false);
        return (int)renderer.getLastWidth();
    }

    @Override
    default public int getDefaultHeight() {
        renderer.setAlignment(Alignment.TopLeft, -1.0f, -1.0f);
        renderer.setScale(this.getScale());
        renderer.setPos(0, 0);
        renderer.setSimulate(true);
        renderer.draw(null, (Component)this.getFormatted());
        renderer.setSimulate(false);
        return (int)renderer.getLastWidth();
    }

    default public float getScale() {
        return 1.0f;
    }

    default public TextWidget<?> asWidget() {
        return new TextWidget(this);
    }

    default public StyledText withStyle() {
        return new StyledText(this);
    }

    default public AnimatedText withAnimation() {
        return new AnimatedText(this);
    }

    @Nullable
    default public FormattingState getFormatting() {
        return null;
    }

    public IKey style(@Nullable ChatFormatting var1);

    default public IKey style(ChatFormatting ... formatting) {
        for (ChatFormatting cf : formatting) {
            this.style(cf);
        }
        return this;
    }

    default public IKey removeFormatColor() {
        return this.style((ChatFormatting)null);
    }

    public IKey removeStyle();

    default public StyledText alignment(Alignment alignment) {
        return this.withStyle().alignment(alignment);
    }

    @NotNull
    default public StyledText color(int color) {
        return this.color(() -> color);
    }

    default public StyledText color(@Nullable IntSupplier color) {
        return this.withStyle().color(color);
    }

    default public StyledText scale(float scale) {
        return this.withStyle().scale(scale);
    }

    default public StyledText shadow(@Nullable Boolean shadow) {
        return this.withStyle().shadow(shadow);
    }

    default public KeyIcon asTextIcon() {
        return new KeyIcon(this);
    }

    @Override
    default public void loadFromJson(JsonObject json) {
        if (json.has("color") || json.has("shadow") || json.has("align") || json.has("alignment") || json.has("scale")) {
            StyledText styledText1;
            StyledText styledText;
            IKey iKey = this;
            StyledText styledText2 = styledText = iKey instanceof StyledText ? (styledText1 = (StyledText)iKey) : this.withStyle();
            if (json.has("color")) {
                styledText.color(JsonHelper.getInt(json, 0, "color"));
            }
            styledText.shadow(JsonHelper.getBoolean(json, false, "shadow"));
            styledText.alignment(JsonHelper.deserialize(json, Alignment.class, styledText.alignment(), "align", "alignment"));
            styledText.scale(JsonHelper.getFloat(json, 1.0f, "scale"));
        }
    }
}

