/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.drawable;

import brachy.modularui.drawable.DrawableStack;
import brachy.modularui.drawable.Icon;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Color;
import brachy.modularui.widget.Widget;
import brachy.modularui.widget.sizer.Area;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface IDrawable {
    public static final IDrawable EMPTY = (context, x, y, width, height, widgetTheme) -> {};
    public static final IDrawable NONE = (context, x, y, width, height, widgetTheme) -> {};

    public static IDrawable of(IDrawable ... drawables) {
        if (drawables == null || drawables.length == 0) {
            return null;
        }
        if (drawables.length == 1) {
            return drawables[0];
        }
        return new DrawableStack(drawables);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext var1, int var2, int var3, int var4, int var5, WidgetTheme var6);

    @OnlyIn(value=Dist.CLIENT)
    default public void drawAtZero(GuiContext context, int width, int height, WidgetTheme widgetTheme) {
        this.draw(context, 0, 0, width, height, widgetTheme);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void draw(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, area.x, area.y, area.width, area.height, widgetTheme);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void drawPadded(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, area.x + area.getPadding().left(), area.y + area.getPadding().top(), area.paddedWidth(), area.paddedHeight(), widgetTheme);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void drawAtZero(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, 0, 0, area.width, area.height, widgetTheme);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void drawAtZeroPadded(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, area.getPadding().left(), area.getPadding().top(), area.paddedWidth(), area.paddedHeight(), widgetTheme);
    }

    default public boolean canApplyTheme() {
        return false;
    }

    default public void applyColor(int themeColor) {
        if (this.canApplyTheme()) {
            Color.setGlColor(themeColor);
        } else {
            Color.setGlColorOpaque(Color.WHITE.main);
        }
    }

    default public int getDefaultWidth() {
        return 0;
    }

    default public int getDefaultHeight() {
        return 0;
    }

    default public Widget<?> asWidget() {
        return new DrawableWidget(this);
    }

    default public Icon asIcon() {
        return new Icon(this).size(this.getDefaultWidth(), this.getDefaultHeight());
    }

    public static boolean isVisible(@Nullable IDrawable drawable) {
        if (drawable == null || drawable == EMPTY || drawable == NONE) {
            return false;
        }
        if (drawable instanceof DrawableStack) {
            DrawableStack array = (DrawableStack)drawable;
            return array.drawables().length > 0;
        }
        return true;
    }

    public static class DrawableWidget
    extends Widget<DrawableWidget> {
        private final IDrawable drawable;

        public DrawableWidget(IDrawable drawable) {
            this.drawable = drawable;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
            this.drawable.drawAtZero(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }
}

