/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api;

import brachy.modularui.api.IMuiScreen;
import brachy.modularui.factory.GuiData;
import brachy.modularui.screen.ContainerScreenWrapper;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.UISettings;
import brachy.modularui.value.sync.PanelSyncManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface UIFactory<D extends GuiData> {
    @NotNull
    public ResourceLocation getFactoryName();

    @ApiStatus.OverrideOnly
    public ModularPanel createPanel(D var1, PanelSyncManager var2, UISettings var3);

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.OverrideOnly
    public ModularScreen createScreen(D var1, ModularPanel var2);

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.OverrideOnly
    default public IMuiScreen createScreenWrapper(ModularContainerMenu container, ModularScreen screen) {
        return new ContainerScreenWrapper(container, screen);
    }

    default public ModularContainerMenu createContainer(int containerId) {
        return new ModularContainerMenu(containerId);
    }

    default public boolean canInteractWith(Player player, D guiData) {
        return player == ((GuiData)guiData).getPlayer();
    }

    @ApiStatus.OverrideOnly
    public void writeGuiData(D var1, FriendlyByteBuf var2);

    @NotNull
    @ApiStatus.OverrideOnly
    public D readGuiData(Player var1, FriendlyByteBuf var2);
}

