/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api;

import brachy.modularui.core.mixins.client.AbstractContainerScreenAccessor;
import brachy.modularui.screen.ClientScreenHandler;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.utils.Rectangle;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public interface IMuiScreen {
    @NotNull
    public ModularScreen screen();

    @ApiStatus.NonExtendable
    default public void handleDrawBackground(GuiGraphics guiGraphics, Consumer<GuiGraphics> drawFunction) {
        if (ClientScreenHandler.shouldDrawWorldBackground()) {
            drawFunction.accept(guiGraphics);
        }
        ClientScreenHandler.drawDarkBackground(this.wrappedScreen(), guiGraphics);
    }

    default public void updateGuiArea(Rectangle area) {
        Screen screen = this.wrappedScreen();
        if (screen instanceof AbstractContainerScreenAccessor) {
            AbstractContainerScreenAccessor acc = (AbstractContainerScreenAccessor)screen;
            acc.setLeftPos(area.x);
            acc.setTopPos(area.y);
            acc.setImageWidth(area.width);
            acc.setImageHeight(area.height);
        }
    }

    @ApiStatus.NonExtendable
    default public boolean isGuiContainer() {
        return this.wrappedScreen() instanceof AbstractContainerScreen;
    }

    @ApiStatus.NonExtendable
    default public void setHoveredSlot(Slot slot) {
        Screen screen = this.wrappedScreen();
        if (screen instanceof AbstractContainerScreenAccessor) {
            AbstractContainerScreenAccessor acc = (AbstractContainerScreenAccessor)screen;
            acc.setHoveredSlot(slot);
        }
    }

    default public Screen wrappedScreen() {
        return (Screen)this;
    }
}

