/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui;

import brachy.modularui.ModularUI;
import brachy.modularui.screen.RichTooltip;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModularUIConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.IntValue DEFAULT_SCROLL_SPEED;
    public static final ForgeConfigSpec.BooleanValue SMOOTH_PROGRESS_BARS;
    public static final ForgeConfigSpec.IntValue ANIMATION_TIME;
    public static final ForgeConfigSpec.EnumValue<RichTooltip.Pos> TOOLTIP_POS;
    public static final ForgeConfigSpec.BooleanValue ESC_RESTORES_LAST_TEXT;
    public static final ForgeConfigSpec.BooleanValue USE_DARK_THEME_BY_DEFAULT;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TEST_GUIS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TEST_OVERLAYS;
    public static final ForgeConfigSpec.BooleanValue REPLACE_VANILLA_TOOLTIPS;
    public static final ForgeConfigSpec.ConfigValue<String> MOD_NAME_FORMAT;
    public static final ForgeConfigSpec.BooleanValue DEBUG_UI;
    public static final ForgeConfigSpec.ConfigValue<String> TEXT_COLOR;
    public static final ForgeConfigSpec.ConfigValue<String> OUTLINE_COLOR;
    public static final ForgeConfigSpec.ConfigValue<String> CURSOR_COLOR;
    public static final ForgeConfigSpec.DoubleValue SCALE;
    public static final ForgeConfigSpec.BooleanValue SHOW_HOVERED;
    public static final ForgeConfigSpec.BooleanValue SHOW_POS;
    public static final ForgeConfigSpec.BooleanValue SHOW_SIZE;
    public static final ForgeConfigSpec.BooleanValue SHOW_WIDGET_THEME;
    public static final ForgeConfigSpec.BooleanValue SHOW_EXTRA;
    public static final ForgeConfigSpec.BooleanValue SHOW_OUTLINE;
    public static final ForgeConfigSpec.BooleanValue SHOW_PARENT;
    public static final ForgeConfigSpec.BooleanValue SHOW_PARENT_POS;
    public static final ForgeConfigSpec.BooleanValue SHOW_PARENT_SIZE;
    public static final ForgeConfigSpec.BooleanValue SHOW_PARENT_WIDGET_THEME;
    public static final ForgeConfigSpec.BooleanValue SHOW_PARENT_OUTLINE;
    private static String lastValue;
    private static ChatFormatting[] lastParsed;

    public static int defaultScrollSpeed() {
        return (Integer)DEFAULT_SCROLL_SPEED.get();
    }

    public static boolean smoothProgressBars() {
        return (Boolean)SMOOTH_PROGRESS_BARS.get();
    }

    public static int animationTime() {
        return (Integer)ANIMATION_TIME.get();
    }

    public static RichTooltip.Pos tooltipPos() {
        return (RichTooltip.Pos)((Object)TOOLTIP_POS.get());
    }

    public static boolean escRestoresLastText() {
        return (Boolean)ESC_RESTORES_LAST_TEXT.get();
    }

    public static boolean useDarkThemeByDefault() {
        return (Boolean)USE_DARK_THEME_BY_DEFAULT.get();
    }

    public static boolean enableTestGuis() {
        return (Boolean)ENABLE_TEST_GUIS.get();
    }

    public static boolean enableTestOverlays() {
        return (Boolean)ENABLE_TEST_OVERLAYS.get();
    }

    public static boolean replaceVanillaTooltips() {
        return (Boolean)REPLACE_VANILLA_TOOLTIPS.get();
    }

    public static ChatFormatting[] getModNameFormat() {
        String unparsed = (String)MOD_NAME_FORMAT.get();
        if (!Objects.equals(unparsed, lastValue)) {
            lastValue = unparsed;
            String[] split = lastValue.split("\\s");
            lastParsed = new ChatFormatting[split.length];
            for (int i = 0; i < split.length; ++i) {
                String name = split[i];
                ModularUIConfig.lastParsed[i] = ChatFormatting.m_126657_((String)name);
            }
        }
        return lastParsed;
    }

    static {
        BUILDER.push("ui");
        DEFAULT_SCROLL_SPEED = BUILDER.comment("Amount of pixels scrolled").translation("config.modularui.defaultScrollSpeed").defineInRange("defaultScrollSpeed", 30, 1, 100);
        SMOOTH_PROGRESS_BARS = BUILDER.comment("If progress bars should step in texture pixels or screen pixels. (Screen pixels are way smaller and therefore smoother)").translation("config.modularui.smoothProgressBars").define("smoothProgressBars", false);
        ANIMATION_TIME = BUILDER.comment(new String[]{"Duration of UI animations in ms.", "Default: 100"}).translation("config.modularui.animationTime").defineInRange("animationTime", 100, 0, 500);
        TOOLTIP_POS = BUILDER.comment("Default tooltip position around the widget or its panel.").translation("config.modularui.tooltipPos").defineEnum("tooltipPos", (Enum)RichTooltip.Pos.NEXT_TO_MOUSE);
        ESC_RESTORES_LAST_TEXT = BUILDER.comment("If true, pressing ESC key in the text field will restore the last text instead of confirming current one.").translation("config.modularui.escRestoresLastText").define("escRestoresLastText", false);
        USE_DARK_THEME_BY_DEFAULT = BUILDER.comment("If true and not specified otherwise, screens will try to use the 'vanilla_dark' theme.").translation("config.modularui.useDarkThemeByDefault").define("useDarkThemeByDefault", false);
        ENABLE_TEST_GUIS = BUILDER.comment("Enables a test block, test item with a test gui and opening a gui by right clicking a diamond.").translation("config.modularui.enableTestGuis").worldRestart().define("enableTestGuis", ModularUI.isDev());
        ENABLE_TEST_OVERLAYS = BUILDER.comment("Enables a test overlay shown on title screen and watermark shown on every GuiContainer.").translation("config.modularui.enableTestOverlays").worldRestart().define("enableTestOverlays", false);
        REPLACE_VANILLA_TOOLTIPS = BUILDER.comment("If true, vanilla tooltip will be replaced with MUI's RichTooltip").translation("config.modularui.replaceVanillaTooltips").define("replaceVanillaTooltips", false);
        MOD_NAME_FORMAT = BUILDER.comment(new String[]{"The format prefix of the mod name tooltip line.", "Default: 'blue italic' (converted to \u00a79\u00a7o)"}).translation("config.modularui.modNameFormat").define("modNameFormat", (Object)(ChatFormatting.BLUE.m_126666_() + " " + ChatFormatting.ITALIC.m_126666_()));
        BUILDER.pop().push("dev");
        DEBUG_UI = BUILDER.comment(new String[]{"Debug UI? (Will draw widget outlines and widget information)", "Default: false"}).translation("config.modularui.dev.debugUI").define("debugUI", ModularUI.isDev());
        TEXT_COLOR = BUILDER.comment("Color for debug text, in #AARRGGBB").translation("config.modularui.dev.textColor").define("textColor", (Object)"#DCB42873");
        OUTLINE_COLOR = BUILDER.comment("Color for outlining widgets in debug mode, in #AARRGGBB").translation("config.modularui.dev.outlineColor").define("outlineColor", (Object)"#DCB42873");
        CURSOR_COLOR = BUILDER.comment("Color for cursor in debug mode, in #AARRGGBB").translation("config.modularui.dev.cursorColor").define("cursorColor", (Object)"#FF4CAF50");
        SCALE = BUILDER.comment(new String[]{"Scale of debug text", "Default: 0.8f"}).translation("config.modularui.dev.debugTextScale").defineInRange("scale", 0.8, 0.1, 10.0);
        SHOW_HOVERED = BUILDER.translation("config.modularui.dev.showHovered").define("showHovered", true);
        SHOW_POS = BUILDER.translation("config.modularui.dev.showPos").define("showPos", true);
        SHOW_SIZE = BUILDER.translation("config.modularui.dev.showSize").define("showSize", true);
        SHOW_WIDGET_THEME = BUILDER.translation("config.modularui.dev.showWidgetTheme").define("showWidgetTheme", true);
        SHOW_EXTRA = BUILDER.translation("config.modularui.dev.showExtra").define("showExtra", true);
        SHOW_OUTLINE = BUILDER.translation("config.modularui.dev.showOutline").define("showOutline", true);
        SHOW_PARENT = BUILDER.translation("config.modularui.dev.showParent").define("showParent", true);
        SHOW_PARENT_POS = BUILDER.translation("config.modularui.dev.showParentPos").define("showParentPos", true);
        SHOW_PARENT_SIZE = BUILDER.translation("config.modularui.dev.showParentSize").define("showParentSize", true);
        SHOW_PARENT_WIDGET_THEME = BUILDER.translation("config.modularui.dev.showParentWidgetTheme").define("showParentWidgetTheme", true);
        SHOW_PARENT_OUTLINE = BUILDER.translation("config.modularui.dev.showParentOutline").define("showParentOutline", true);
        BUILDER.pop();
        CONFIG = BUILDER.build();
        lastValue = null;
        lastParsed = null;
    }

    public static final class Dev {
        private Dev() {
        }

        public static boolean debugUI() {
            return (Boolean)DEBUG_UI.get();
        }

        public static int textColor() {
            return Long.decode((String)TEXT_COLOR.get()).intValue();
        }

        public static int outlineColor() {
            return Long.decode((String)OUTLINE_COLOR.get()).intValue();
        }

        public static int cursorColor() {
            return Long.decode((String)CURSOR_COLOR.get()).intValue();
        }

        public static float scale() {
            return ((Double)SCALE.get()).floatValue();
        }

        public static boolean showHovered() {
            return (Boolean)SHOW_HOVERED.get();
        }

        public static boolean showPos() {
            return (Boolean)SHOW_POS.get();
        }

        public static boolean showSize() {
            return (Boolean)SHOW_SIZE.get();
        }

        public static boolean showWidgetTheme() {
            return (Boolean)SHOW_WIDGET_THEME.get();
        }

        public static boolean showExtra() {
            return (Boolean)SHOW_EXTRA.get();
        }

        public static boolean showOutline() {
            return (Boolean)SHOW_OUTLINE.get();
        }

        public static boolean showParent() {
            return (Boolean)SHOW_PARENT.get();
        }

        public static boolean showParentPos() {
            return (Boolean)SHOW_PARENT_POS.get();
        }

        public static boolean showParentSize() {
            return (Boolean)SHOW_PARENT_SIZE.get();
        }

        public static boolean showParentWidgetTheme() {
            return (Boolean)SHOW_PARENT_WIDGET_THEME.get();
        }

        public static boolean showParentOutline() {
            return (Boolean)SHOW_PARENT_OUTLINE.get();
        }
    }
}

