/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.InvalidPatternHelper;
import appeng.items.AEBaseItem;
import appeng.items.misc.WrappedGenericStack;
import appeng.util.InteractionUtil;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class EncodedPatternItem
extends AEBaseItem {
    private static final Map<ItemStack, ItemStack> SIMPLE_CACHE = new WeakHashMap<ItemStack, ItemStack>();

    public EncodedPatternItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void addToMainCreativeTab(CreativeModeTab.Output output) {
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        this.clearPattern(player.m_21120_(hand), player);
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)player.m_21120_(hand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.clearPattern(stack, context.m_43723_()) ? InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()) : InteractionResult.PASS;
    }

    private boolean clearPattern(ItemStack stack, Player player) {
        if (InteractionUtil.isInAlternateUseMode(player)) {
            if (player.m_20193_().m_5776_()) {
                return false;
            }
            Inventory inv = player.m_150109_();
            ItemStack is = AEItems.BLANK_PATTERN.stack(stack.m_41613_());
            if (!is.m_41619_()) {
                for (int s = 0; s < player.m_150109_().m_6643_(); ++s) {
                    if (inv.m_8020_(s) != stack) continue;
                    inv.m_6836_(s, is);
                    return true;
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        boolean isCrafting;
        if (!stack.m_41782_()) {
            return;
        }
        IPatternDetails details = this.decode(stack, level, false);
        if (details == null) {
            stack.m_41714_((Component)GuiText.InvalidPattern.text().m_6881_().m_130940_(ChatFormatting.RED));
            InvalidPatternHelper invalid = new InvalidPatternHelper(stack);
            MutableComponent label = (invalid.isCraftable() ? GuiText.Crafts.text() : GuiText.Produces.text()).m_130940_(ChatFormatting.DARK_AQUA);
            MutableComponent ingredients = Component.m_237119_().m_7220_((Component)GuiText.Ingredients.text().m_130940_(ChatFormatting.DARK_GREEN));
            boolean first = true;
            for (InvalidPatternHelper.PatternIngredient output : invalid.getOutputs()) {
                if (first) {
                    lines.add((Component)label);
                }
                lines.add((Component)Component.m_237113_((String)"  ").m_7220_(output.getFormattedToolTip()));
                first = false;
            }
            first = true;
            for (InvalidPatternHelper.PatternIngredient input : invalid.getInputs()) {
                if (first) {
                    lines.add((Component)ingredients);
                }
                lines.add((Component)Component.m_237113_((String)"  ").m_7220_(input.getFormattedToolTip()));
                first = false;
            }
            if (invalid.isCraftable()) {
                MutableComponent canSubstitute = invalid.canSubstitute() ? GuiText.Yes.text() : GuiText.No.text();
                MutableComponent substitutionLabel = GuiText.Substitute.text(canSubstitute);
                lines.add((Component)substitutionLabel);
            }
            return;
        }
        if (stack.m_41788_()) {
            stack.m_41787_();
        }
        boolean substitute = (isCrafting = details instanceof AECraftingPattern) && ((AECraftingPattern)details).canSubstitute;
        boolean substituteFluids = isCrafting && ((AECraftingPattern)details).canSubstituteFluids;
        String author = details.getAuthor();
        IPatternDetails.IInput[] in = details.getInputs();
        GenericStack[] out = details.getOutputs();
        MutableComponent label = (isCrafting ? GuiText.Crafts.text() : GuiText.Produces.text()).m_130940_(ChatFormatting.DARK_AQUA);
        MutableComponent ingredients = GuiText.Ingredients.text().m_130940_(ChatFormatting.DARK_GREEN);
        boolean first = true;
        for (GenericStack anOut : out) {
            if (anOut == null) continue;
            if (first) {
                lines.add((Component)label);
            }
            lines.add((Component)Component.m_237113_((String)"  ").m_7220_(EncodedPatternItem.getStackComponent(anOut, false)));
            first = false;
        }
        first = true;
        for (IPatternDetails.IInput anIn : in) {
            if (anIn == null) continue;
            GenericStack primaryInputTemplate = anIn.getPossibleInputs()[0];
            GenericStack primaryInput = new GenericStack(primaryInputTemplate.what(), primaryInputTemplate.amount() * anIn.getMultiplier());
            if (first) {
                lines.add((Component)ingredients);
            }
            lines.add((Component)Component.m_237113_((String)"  ").m_7220_(EncodedPatternItem.getStackComponent(primaryInput, true)));
            first = false;
        }
        if (isCrafting) {
            MutableComponent yes = GuiText.Yes.text().m_130940_(ChatFormatting.GREEN);
            MutableComponent no = GuiText.No.text().m_130940_(ChatFormatting.RED);
            MutableComponent canSubstitute = substitute ? yes : no;
            MutableComponent canSubstituteFluids = substituteFluids ? yes : no;
            MutableComponent substitutionLabel = GuiText.Substitute.text(canSubstitute);
            MutableComponent fluidSubstitutionLabel = GuiText.FluidSubstitutions.text(canSubstituteFluids);
            lines.add((Component)substitutionLabel);
            lines.add((Component)fluidSubstitutionLabel);
        }
        if (!author.isEmpty()) {
            lines.add((Component)GuiText.EncodedBy.text(author).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }

    protected static Component getStackComponent(GenericStack stack, boolean isInput) {
        AEKeyType type = stack.what().getType();
        AEKey what = stack.what();
        MutableComponent displayName = what.getDisplayName().m_6879_();
        if (type == AEKeyType.items()) {
            displayName.m_130940_(isInput ? ChatFormatting.GREEN : ChatFormatting.YELLOW);
        } else {
            displayName.m_130940_(isInput ? ChatFormatting.AQUA : ChatFormatting.BLUE);
        }
        String amountInfo = what.formatAmount(stack.amount(), AmountFormat.FULL);
        return Component.m_237113_((String)(amountInfo + " \u00a77x ")).m_7220_((Component)displayName);
    }

    public ItemStack getOutput(ItemStack item) {
        ItemStack out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        Level level = AppEng.instance().getClientLevel();
        if (level == null) {
            return ItemStack.f_41583_;
        }
        IPatternDetails details = this.decode(item, level, false);
        out = ItemStack.f_41583_;
        if (details != null) {
            GenericStack output = details.getPrimaryOutput();
            AEKey aEKey = output.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                out = itemKey.toStack();
            } else {
                out = WrappedGenericStack.wrap(output.what(), 0L);
            }
        }
        SIMPLE_CACHE.put(item, out);
        return out;
    }

    @Nullable
    public abstract IPatternDetails decode(ItemStack var1, Level var2, boolean var3);

    @Nullable
    public abstract IPatternDetails decode(AEItemKey var1, Level var2);
}

