/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import com.google.common.base.Preconditions;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraftforge.common.crafting.IShapedRecipe;

public final class CraftingRecipeUtil {
    private CraftingRecipeUtil() {
    }

    public static NonNullList<Ingredient> ensure3by3CraftingMatrix(Recipe<?> recipe) {
        NonNullList<Ingredient> ingredients = CraftingRecipeUtil.getIngredients(recipe);
        NonNullList expandedIngredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        Preconditions.checkArgument((ingredients.size() <= 9 ? 1 : 0) != 0);
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            int width = shapedRecipe.getRecipeWidth();
            int height = shapedRecipe.getRecipeHeight();
            Preconditions.checkArgument((width <= 3 && height <= 3 ? 1 : 0) != 0);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int source = w + h * width;
                    int target = w + h * 3;
                    Ingredient i = (Ingredient)ingredients.get(source);
                    expandedIngredients.set(target, (Object)i);
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                expandedIngredients.set(i, (Object)((Ingredient)ingredients.get(i)));
            }
        }
        return expandedIngredients;
    }

    public static NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            NonNullList ingredients = NonNullList.m_122780_((int)3, (Object)Ingredient.f_43901_);
            ingredients.set(0, (Object)trimRecipe.f_265958_);
            ingredients.set(1, (Object)trimRecipe.f_266040_);
            ingredients.set(2, (Object)trimRecipe.f_266053_);
            return ingredients;
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            NonNullList ingredients = NonNullList.m_122780_((int)3, (Object)Ingredient.f_43901_);
            ingredients.set(0, (Object)transformRecipe.f_265949_);
            ingredients.set(1, (Object)transformRecipe.f_265888_);
            ingredients.set(2, (Object)transformRecipe.f_265907_);
            return ingredients;
        }
        return recipe.m_7527_();
    }
}

