/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ISubMenuHost;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfirmAutoCraftPacket;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.InaccessibleSlot;
import appeng.util.inv.AppEngInternalInventory;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CraftAmountMenu
extends AEBaseMenu
implements ISubMenu {
    public static final MenuType<CraftAmountMenu> TYPE = MenuTypeBuilder.create(CraftAmountMenu::new, ISubMenuHost.class).build("craftamount");
    private final AppEngSlot craftingItem;
    private AEKey whatToCraft;
    private final ISubMenuHost host;

    public CraftAmountMenu(int id, Inventory ip, ISubMenuHost host) {
        super(TYPE, id, ip, host);
        this.host = host;
        this.craftingItem = new InaccessibleSlot(new AppEngInternalInventory(1), 0);
        this.craftingItem.setHideAmount(true);
        this.addSlot(this.craftingItem, SlotSemantics.MACHINE_OUTPUT);
    }

    @Override
    public ISubMenuHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuLocator locator, AEKey whatToCraft, long initialAmount) {
        MenuOpener.open(TYPE, (Player)player, locator);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof CraftAmountMenu) {
            CraftAmountMenu cca = (CraftAmountMenu)abstractContainerMenu;
            cca.setWhatToCraft(whatToCraft, initialAmount);
            cca.m_38946_();
        }
    }

    public Level getLevel() {
        return this.getPlayerInventory().f_35978_.m_9236_();
    }

    private void setWhatToCraft(AEKey whatToCraft, long initialAmount) {
        this.whatToCraft = Objects.requireNonNull(whatToCraft, "whatToCraft");
        this.craftingItem.m_5852_(GenericStack.wrapInItemStack(whatToCraft, initialAmount));
    }

    public void confirm(long amount, boolean craftMissingAmount, boolean autoStart) {
        MenuLocator locator;
        IGridNode node;
        IActionHost host;
        if (!this.isServerSide()) {
            NetworkHandler.instance().sendToServer(new ConfirmAutoCraftPacket(amount, craftMissingAmount, autoStart));
            return;
        }
        if (this.whatToCraft == null) {
            return;
        }
        if (craftMissingAmount && (host = this.getActionHost()) != null && (node = host.getActionableNode()) != null) {
            IStorageService storage = node.getGrid().getStorageService();
            long existingAmount = Math.min(storage.getCachedInventory().get(this.whatToCraft), Long.MAX_VALUE);
            amount = existingAmount > amount ? 0L : (amount -= existingAmount);
        }
        if ((locator = this.getLocator()) != null) {
            Player player = this.getPlayer();
            if (amount > 0L) {
                MenuOpener.open(CraftConfirmMenu.TYPE, player, locator);
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (abstractContainerMenu instanceof CraftConfirmMenu) {
                    CraftConfirmMenu ccc = (CraftConfirmMenu)abstractContainerMenu;
                    ccc.setAutoStart(autoStart);
                    ccc.planJob(this.whatToCraft, amount, CalculationStrategy.REPORT_MISSING_ITEMS);
                    this.m_38946_();
                }
            } else {
                this.host.returnToMainMenu(player, this);
            }
        }
    }

    @Nullable
    public GenericStack getWhatToCraft() {
        return GenericStack.unwrapItemStack(this.craftingItem.m_7993_());
    }
}

