/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.crafting.AbstractTableRenderer;
import appeng.core.localization.GuiText;
import appeng.menu.me.crafting.CraftingPlanSummaryEntry;
import appeng.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class CraftConfirmTableRenderer
extends AbstractTableRenderer<CraftingPlanSummaryEntry> {
    public CraftConfirmTableRenderer(AEBaseScreen<?> screen, int x, int y) {
        super(screen, x, y, 5);
    }

    @Override
    protected List<Component> getEntryDescription(CraftingPlanSummaryEntry entry) {
        String amount;
        ArrayList<Component> lines = new ArrayList<Component>(3);
        if (entry.storedAmount() > 0L) {
            amount = entry.what().formatAmount(entry.storedAmount(), AmountFormat.SLOT);
            lines.add((Component)GuiText.FromStorage.text(amount));
        }
        if (entry.missingAmount() > 0L) {
            amount = entry.what().formatAmount(entry.missingAmount(), AmountFormat.SLOT);
            lines.add((Component)GuiText.Missing.text(amount));
        }
        if (entry.craftAmount() > 0L) {
            amount = entry.what().formatAmount(entry.craftAmount(), AmountFormat.SLOT);
            lines.add((Component)GuiText.ToCraft.text(amount));
        }
        if (entry.storedAmount() > 0L) {
            Component percentage = NumberUtil.createPercentageComponent(entry.storedAmount(), entry.availableAmount());
            lines.add((Component)GuiText.UsedAmount.text().m_130948_(percentage.m_7383_()).m_7220_(percentage));
        }
        return lines;
    }

    @Override
    protected AEKey getEntryStack(CraftingPlanSummaryEntry entry) {
        return entry.what();
    }

    @Override
    protected List<Component> getEntryTooltip(CraftingPlanSummaryEntry entry) {
        List<Component> lines = AEKeyRendering.getTooltip(entry.what());
        if (entry.storedAmount() > 0L) {
            lines.add((Component)GuiText.FromStorage.text(entry.what().formatAmount(entry.storedAmount(), AmountFormat.FULL)));
        }
        if (entry.missingAmount() > 0L) {
            lines.add((Component)GuiText.Missing.text(entry.what().formatAmount(entry.missingAmount(), AmountFormat.FULL)));
        }
        if (entry.craftAmount() > 0L) {
            lines.add((Component)GuiText.ToCraft.text(entry.what().formatAmount(entry.craftAmount(), AmountFormat.FULL)));
        }
        if (entry.storedAmount() > 0L) {
            Component percentage = NumberUtil.createPercentageComponent(entry.storedAmount(), entry.availableAmount());
            lines.add((Component)GuiText.UsedAmount.text().m_130948_(percentage.m_7383_()).m_7220_(percentage));
        }
        return lines;
    }

    @Override
    protected int getEntryOverlayColor(CraftingPlanSummaryEntry entry) {
        return entry.missingAmount() > 0L ? 452919296 : 0;
    }
}

