/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEKey;
import appeng.client.gui.me.common.FinishedJobToast;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.packets.CraftingJobStatusPacket;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.util.NumberUtil;
import appeng.util.SearchInventoryEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.time.DurationFormatUtils;

@OnlyIn(value=Dist.CLIENT)
public final class PendingCraftingJobs {
    private static final Map<UUID, PendingJob> jobs = new HashMap<UUID, PendingJob>();

    private PendingCraftingJobs() {
    }

    public static boolean hasPendingJob(AEKey what) {
        return jobs.entrySet().stream().anyMatch(s -> ((PendingJob)s.getValue()).what.equals(what));
    }

    public static void clearPendingJobs() {
        jobs.clear();
    }

    public static void jobStatus(UUID id, AEKey what, long requestedAmount, long remainingAmount, long elapsedTime, CraftingJobStatusPacket.Status status) {
        AELog.debug("Crafting job " + id + " for " + requestedAmount + "x" + AEKeyRendering.getDisplayName(what).getString() + ". State=" + status, new Object[0]);
        PendingJob existing = jobs.get(id);
        switch (status) {
            case STARTED: {
                if (existing != null) break;
                jobs.put(id, new PendingJob(id, what, requestedAmount, remainingAmount));
                break;
            }
            case CANCELLED: {
                jobs.remove(id);
                break;
            }
            case FINISHED: {
                jobs.remove(id);
                Minecraft minecraft = Minecraft.m_91087_();
                if (!AEConfig.instance().isNotifyForFinishedCraftingJobs() || minecraft.f_91080_ instanceof MEStorageScreen || minecraft.f_91074_ == null || !PendingCraftingJobs.hasNotificationEnablingItem(minecraft.f_91074_)) break;
                minecraft.m_91300_().m_94922_((Toast)new FinishedJobToast(what, requestedAmount));
                MutableComponent amount = Component.m_237113_((String)NumberUtil.formatNumber(requestedAmount)).m_130940_(ChatFormatting.GREEN).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("\u00a7a" + requestedAmount)))));
                MutableComponent item = what.getDisplayName().m_6881_().m_130940_(ChatFormatting.AQUA);
                MutableComponent duration = Component.m_237113_((String)DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis(elapsedTime), (String)"HH:mm:ss")).m_130940_(ChatFormatting.GREEN);
                minecraft.f_91074_.m_213846_((Component)PlayerMessages.CraftJobFinished.text(amount, item, duration));
            }
        }
    }

    private static boolean hasNotificationEnablingItem(LocalPlayer player) {
        for (ItemStack stack : SearchInventoryEvent.getItems((Player)player)) {
            WirelessTerminalItem wirelessTerminal;
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof WirelessTerminalItem) || !((wirelessTerminal = (WirelessTerminalItem)item).getAECurrentPower(stack) > 0.0) || wirelessTerminal.getLinkedPosition(stack) == null) continue;
            return true;
        }
        return false;
    }

    record PendingJob(UUID jobId, AEKey what, long requestedAmount, long remainingAmount) {
    }
}

