/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.config.ActionItems;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.StackWithBounds;
import appeng.client.gui.me.crafting.CraftConfirmTableRenderer;
import appeng.client.gui.me.crafting.CraftErrorScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.helpers.CraftExporter;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.me.crafting.CraftingPlanSummary;
import appeng.menu.me.crafting.CraftingPlanSummaryEntry;
import appeng.util.NumberUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class CraftConfirmScreen
extends AEBaseScreen<CraftConfirmMenu> {
    private final CraftConfirmTableRenderer table;
    private final Button start;
    private final Button startWithFollow;
    private final Button selectCPU;
    private final Scrollbar scrollbar;
    private final boolean isNotifyForFinishedCraftingJobs = AEConfig.instance().isNotifyForFinishedCraftingJobs();

    public CraftConfirmScreen(CraftConfirmMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.table = new CraftConfirmTableRenderer(this, 9, 19);
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.start = this.widgets.addButton("start", (Component)GuiText.Start.text(), () -> this.start(this.isNotifyForFinishedCraftingJobs));
        this.start.f_93623_ = false;
        this.startWithFollow = this.widgets.addButton("startWithFollow", (Component)GuiText.StartWithFollow.text(), () -> this.start(true));
        this.startWithFollow.f_93623_ = false;
        this.selectCPU = this.widgets.addButton("selectCpu", this.getNextCpuButtonLabel(), this::selectNextCpu);
        this.selectCPU.f_93623_ = false;
        this.addToLeftToolbar(new ActionButton(ActionItems.EXPORT_CRAFT, this::exportCraft));
        this.widgets.addButton("cancel", (Component)GuiText.Cancel.text(), menu::goBack);
    }

    @Override
    protected void updateBeforeRender() {
        boolean start;
        super.updateBeforeRender();
        ICraftingSubmitResult errorResult = ((CraftConfirmMenu)this.f_97732_).submitError.result();
        if (errorResult != null && errorResult.errorCode() != null) {
            this.switchToScreen(new CraftErrorScreen(this, errorResult.errorCode(), errorResult.errorDetail()));
            return;
        }
        this.selectCPU.m_93666_(this.getNextCpuButtonLabel());
        CraftingPlanSummary plan = ((CraftConfirmMenu)this.f_97732_).getPlan();
        boolean planIsStartable = plan != null && !plan.simulation();
        this.start.f_93623_ = start = !((CraftConfirmMenu)this.f_97732_).hasNoCPU() && planIsStartable;
        this.startWithFollow.f_93623_ = start;
        this.startWithFollow.f_93624_ = !this.isNotifyForFinishedCraftingJobs;
        this.selectCPU.f_93623_ = planIsStartable;
        MutableComponent planDetails = GuiText.CalculatingWait.text();
        MutableComponent cpuDetails = Component.m_237119_();
        if (plan != null) {
            String byteUsed = NumberUtil.formatNumber(plan.usedBytes());
            planDetails = GuiText.BytesUsed.text(byteUsed);
            cpuDetails = plan.simulation() ? GuiText.PartialPlan.text() : (((CraftConfirmMenu)this.f_97732_).getCpuAvailableBytes() > 0L ? GuiText.ConfirmCraftCpuStatus.text(NumberUtil.formatNumber(((CraftConfirmMenu)this.f_97732_).getCpuAvailableBytes()), NumberUtil.formatNumber(((CraftConfirmMenu)this.f_97732_).getCpuCoProcessors())) : GuiText.ConfirmCraftNoCpu.text());
        }
        this.setTextContent("dialog_title", (Component)GuiText.CraftingPlan.text(planDetails));
        this.setTextContent("cpu_status", (Component)cpuDetails);
        int size = plan != null ? plan.entries().size() : 0;
        this.scrollbar.setRange(0, this.table.getScrollableRows(size), 1);
    }

    private Component getNextCpuButtonLabel() {
        if (((CraftConfirmMenu)this.f_97732_).hasNoCPU()) {
            return GuiText.NoCraftingCPUs.text();
        }
        Object cpuName = ((CraftConfirmMenu)this.f_97732_).cpuName == null ? GuiText.Automatic.text() : ((CraftConfirmMenu)this.f_97732_).cpuName;
        return GuiText.SelectedCraftingCPU.text(cpuName);
    }

    @Override
    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        CraftingPlanSummary plan = ((CraftConfirmMenu)this.f_97732_).getPlan();
        if (plan != null) {
            this.table.render(guiGraphics, mouseX, mouseY, plan.entries(), this.scrollbar.getCurrentScroll());
        }
    }

    @Override
    @Nullable
    public StackWithBounds getStackUnderMouse(double mouseX, double mouseY) {
        StackWithBounds hovered = this.table.getHoveredStack();
        if (hovered != null) {
            return hovered;
        }
        return super.getStackUnderMouse(mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode == 257 || keyCode == 335) {
            this.start(this.isNotifyForFinishedCraftingJobs);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, p_keyPressed_3_);
    }

    private void selectNextCpu() {
        ((CraftConfirmMenu)this.m_6262_()).cycleSelectedCPU(!this.isHandlingRightClick());
    }

    private void start(boolean isFollowing) {
        ((CraftConfirmMenu)this.m_6262_()).startJob(isFollowing);
    }

    private void exportCraft() {
        CraftingPlanSummary plan = ((CraftConfirmMenu)this.f_97732_).getPlan();
        JsonObject exportObject = new JsonObject();
        JsonObject cpuStats = new JsonObject();
        cpuStats.addProperty("name", ((CraftConfirmMenu)this.f_97732_).cpuName != null ? ((CraftConfirmMenu)this.f_97732_).cpuName.getString() : GuiText.Automatic.getEnglishText());
        cpuStats.addProperty("isFollowing", Boolean.valueOf(((CraftConfirmMenu)this.f_97732_).isFollowing));
        cpuStats.addProperty("availableBytes", (Number)((CraftConfirmMenu)this.f_97732_).getCpuAvailableBytes());
        cpuStats.addProperty("coProcessors", (Number)((CraftConfirmMenu)this.f_97732_).getCpuCoProcessors());
        cpuStats.addProperty("usedBytes", (Number)plan.usedBytes());
        exportObject.add("cpu", (JsonElement)cpuStats);
        JsonArray entryArray = new JsonArray();
        for (CraftingPlanSummaryEntry entry : plan.entries()) {
            JsonObject entryObject = new JsonObject();
            entryObject.addProperty("what", entry.what().getId().toString());
            entryObject.addProperty("missingAmount", (Number)entry.missingAmount());
            entryObject.addProperty("storedAmount", (Number)entry.storedAmount());
            entryObject.addProperty("craftAmount", (Number)entry.craftAmount());
            entryObject.addProperty("availableAmount", (Number)entry.availableAmount());
            entryArray.add((JsonElement)entryObject);
        }
        exportObject.add("entries", (JsonElement)entryArray);
        CraftExporter.exportCraft(exportObject, this.getPlayer(), CraftExporter.ExportType.CRAFTING_PLAN);
    }
}

