/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.api.orientation.RelativeSide;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.networking.WirelessAccessPointBlockEntity;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.WirelessAccessPointMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WirelessAccessPointBlock
extends AEBaseEntityBlock<WirelessAccessPointBlockEntity>
implements SimpleWaterloggedBlock {
    public static final EnumProperty<State> STATE = EnumProperty.m_61587_((String)"state", State.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public WirelessAccessPointBlock() {
        super(WirelessAccessPointBlock.glassProps().m_60955_().m_280606_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)State.OFF))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, WirelessAccessPointBlockEntity be) {
        State teState = State.OFF;
        if (be.isActive()) {
            teState = State.HAS_CHANNEL;
        } else if (be.isPowered()) {
            teState = State.ON;
        }
        return (BlockState)currentState.m_61124_(STATE, (Comparable)((Object)teState));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATE});
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        WirelessAccessPointBlockEntity tg = (WirelessAccessPointBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (tg != null && !InteractionUtil.isInAlternateUseMode(player)) {
            if (!level.m_5776_()) {
                hit.m_82434_();
                MenuOpener.open(WirelessAccessPointMenu.TYPE, player, MenuLocators.forBlockEntity(tg));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    @NotNull
    private VoxelShape getVoxelShape(BlockState state) {
        BlockOrientation orientation = this.getOrientation(state);
        Direction forward = orientation.getSide(RelativeSide.FRONT);
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        switch (forward) {
            case DOWN: {
                minX = 0.1875;
                minZ = 0.1875;
                maxX = 0.8125;
                maxZ = 0.8125;
                maxY = 1.0;
                minY = 0.3125;
                break;
            }
            case EAST: {
                minY = 0.1875;
                minZ = 0.1875;
                maxY = 0.8125;
                maxZ = 0.8125;
                maxX = 0.6875;
                minX = 0.0;
                break;
            }
            case NORTH: {
                minX = 0.1875;
                minY = 0.1875;
                maxX = 0.8125;
                maxY = 0.8125;
                maxZ = 1.0;
                minZ = 0.3125;
                break;
            }
            case SOUTH: {
                minX = 0.1875;
                minY = 0.1875;
                maxX = 0.8125;
                maxY = 0.8125;
                maxZ = 0.6875;
                minZ = 0.0;
                break;
            }
            case UP: {
                minX = 0.1875;
                minZ = 0.1875;
                maxX = 0.8125;
                maxZ = 0.8125;
                maxY = 0.6875;
                minY = 0.0;
                break;
            }
            case WEST: {
                minY = 0.1875;
                minZ = 0.1875;
                maxY = 0.8125;
                maxZ = 0.8125;
                maxX = 1.0;
                minX = 0.3125;
                break;
            }
        }
        return Shapes.m_83064_((AABB)new AABB(minX, minY, minZ, maxX, maxY, maxZ));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.facing();
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, facing, facingState, level, currentPos, facingPos);
    }

    public static enum State implements StringRepresentable
    {
        OFF,
        ON,
        HAS_CHANNEL;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

