/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.IPatternDetailsDecoder;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AEPatternDecoder;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class PatternDetailsHelper {
    private static final List<IPatternDetailsDecoder> DECODERS = new CopyOnWriteArrayList<IPatternDetailsDecoder>();

    public static void registerDecoder(IPatternDetailsDecoder decoder) {
        Objects.requireNonNull(decoder);
        DECODERS.add(decoder);
    }

    public static boolean isEncodedPattern(ItemStack stack) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            if (!decoder.isEncodedPattern(stack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static IPatternDetails decodePattern(ItemStack stack, Level level) {
        return PatternDetailsHelper.decodePattern(stack, level, false);
    }

    @Nullable
    public static IPatternDetails decodePattern(AEItemKey what, Level level) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            IPatternDetails decoded = decoder.decodePattern(what, level);
            if (decoded == null) continue;
            return decoded;
        }
        return null;
    }

    @Nullable
    public static IPatternDetails decodePattern(ItemStack stack, Level level, boolean autoRecovery) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            IPatternDetails decoded = decoder.decodePattern(stack, level, autoRecovery);
            if (decoded == null) continue;
            return decoded;
        }
        return null;
    }

    public static ItemStack encodeProcessingPattern(GenericStack[] in, GenericStack[] out, String author) {
        return AEItems.PROCESSING_PATTERN.m_5456_().encode(in, out, author);
    }

    public static ItemStack encodeCraftingPattern(CraftingRecipe recipe, ItemStack[] in, ItemStack out, boolean allowSubstitutes, boolean allowFluidSubstitutes, String author) {
        return AEItems.CRAFTING_PATTERN.m_5456_().encode(recipe, in, out, allowSubstitutes, allowFluidSubstitutes, author);
    }

    public static ItemStack encodeStonecuttingPattern(StonecutterRecipe recipe, AEItemKey in, AEItemKey out, boolean allowSubstitutes, String author) {
        Preconditions.checkNotNull((Object)recipe, (Object)"recipe");
        Preconditions.checkNotNull((Object)in, (Object)"in");
        Preconditions.checkNotNull((Object)out, (Object)"out");
        return AEItems.STONECUTTING_PATTERN.m_5456_().encode(recipe, in, out, allowSubstitutes, author);
    }

    public static ItemStack encodeSmithingTablePattern(SmithingRecipe recipe, AEItemKey template, AEItemKey base, AEItemKey addition, AEItemKey out, boolean allowSubstitutes, String author) {
        Preconditions.checkNotNull((Object)recipe, (Object)"recipe");
        Preconditions.checkNotNull((Object)recipe, (Object)"template");
        Preconditions.checkNotNull((Object)base, (Object)"base");
        Preconditions.checkNotNull((Object)addition, (Object)"addition");
        Preconditions.checkNotNull((Object)out, (Object)"out");
        return AEItems.SMITHING_TABLE_PATTERN.m_5456_().encode(recipe, template, base, addition, out, allowSubstitutes, author);
    }

    static {
        PatternDetailsHelper.registerDecoder(AEPatternDecoder.INSTANCE);
    }
}

