/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.StonecutterRecipe;

class StonecuttingPatternEncoding {
    private static final String NBT_INPUT = "in";
    private static final String NBT_OUTPUT = "out";
    private static final String NBT_SUBSITUTE = "substitute";
    private static final String NBT_RECIPE_ID = "recipe";
    private static final String NBT_AUTHOR = "author";

    StonecuttingPatternEncoding() {
    }

    public static AEItemKey getInput(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have an in tag.");
        return AEItemKey.fromTag(nbt.m_128469_(NBT_INPUT));
    }

    public static AEItemKey getOutput(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have an out tag.");
        return AEItemKey.fromTag(nbt.m_128469_(NBT_OUTPUT));
    }

    public static boolean canSubstitute(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.m_128471_(NBT_SUBSITUTE);
    }

    public static ResourceLocation getRecipeId(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return new ResourceLocation(nbt.m_128461_(NBT_RECIPE_ID));
    }

    public static String getAuthor(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.m_128461_(NBT_AUTHOR);
    }

    public static void encode(CompoundTag tag, StonecutterRecipe recipe, AEItemKey input, AEItemKey output, boolean allowSubstitution, String author) {
        tag.m_128365_(NBT_INPUT, (Tag)input.toTag());
        tag.m_128365_(NBT_OUTPUT, (Tag)output.toTag());
        tag.m_128379_(NBT_SUBSITUTE, allowSubstitution);
        tag.m_128359_(NBT_RECIPE_ID, recipe.m_6423_().toString());
        tag.m_128359_(NBT_AUTHOR, author);
    }
}

