/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.stacks.AEKey;
import appeng.client.render.BlockHighlightHandler;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.BasePacket;
import appeng.menu.me.crafting.CraftingCPUMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class BlockHighlightPacket
extends BasePacket {
    private final BlockPos pos;
    private final ResourceKey<Level> level;
    private final long time;

    public BlockHighlightPacket(FriendlyByteBuf stream) {
        this.pos = stream.m_130135_();
        this.level = stream.m_236801_(Registries.f_256858_);
        this.time = stream.readLong();
    }

    public BlockHighlightPacket(BlockPos pos, ResourceKey<Level> level, long time) {
        this.pos = pos;
        this.level = level;
        this.time = time;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130064_(pos);
        data.m_236858_(level);
        data.writeLong(time);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(Player player) {
        BlockHighlightHandler.highlight(this.pos, this.level, this.time);
        player.m_213846_((Component)PlayerMessages.HighlightedBlock.text(Component.m_237113_((String)("\u00a7b" + this.pos.m_123341_() + ", " + this.pos.m_123342_() + ", " + this.pos.m_123343_())), Component.m_237113_((String)("\u00a7a" + this.level.m_135782_()))));
    }

    public static class HighlightWhat
    extends BasePacket {
        private final AEKey what;

        public HighlightWhat(FriendlyByteBuf stream) {
            this.what = AEKey.readKey(stream);
        }

        public HighlightWhat(AEKey what) {
            this.what = what;
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            data.writeInt(this.getPacketID());
            AEKey.writeKey(data, what);
            this.configureWrite(data);
        }

        @Override
        public void serverPacketData(ServerPlayer player) {
            AbstractContainerMenu menu = player.f_36096_;
            if (menu instanceof CraftingCPUMenu) {
                CraftingCPUMenu cpuMenu = (CraftingCPUMenu)menu;
                cpuMenu.highlight(this.what);
            }
        }
    }
}

