/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.BlockingMode;
import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.upgrades.Upgrades;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.PatternProviderLockReason;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.PatternBoxPanel;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.client.gui.widgets.ToolboxPanel;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigButtonPacket;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.PatternProviderMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class PatternProviderScreen<C extends PatternProviderMenu>
extends AEBaseScreen<C> {
    private final SettingToggleButton<YesNo> blockingModeButton;
    private final SettingToggleButton<BlockingMode> extraBlockingModeButton;
    private final SettingToggleButton<LockCraftingMode> lockCraftingModeButton;
    private final ToggleButton showInPatternAccessTerminalButton;
    private final PatternProviderLockReason lockReason;

    public PatternProviderScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.widgets.add("upgrades", new UpgradesPanel(((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.UPGRADE), this::getCompatibleUpgrades));
        this.blockingModeButton = new ServerSettingToggleButton<YesNo>(Settings.BLOCKING_MODE, YesNo.NO);
        this.addToLeftToolbar(this.blockingModeButton);
        this.extraBlockingModeButton = new ServerSettingToggleButton<BlockingMode>(Settings.BLOCKING_MODE_EXTRA, BlockingMode.DEFAULT);
        this.addToLeftToolbar(this.extraBlockingModeButton);
        this.lockCraftingModeButton = new ServerSettingToggleButton<LockCraftingMode>(Settings.LOCK_CRAFTING_MODE, LockCraftingMode.NONE);
        this.addToLeftToolbar(this.lockCraftingModeButton);
        this.widgets.addOpenPriorityButton();
        if (((PatternProviderMenu)((Object)menu)).getToolbox().isPresent()) {
            this.widgets.add("toolbox", new ToolboxPanel(style, ((PatternProviderMenu)((Object)menu)).getToolbox().getName()));
        }
        if (((PatternProviderMenu)((Object)menu)).getPatternBox().isPresent()) {
            this.widgets.add("patternbox", new PatternBoxPanel(style, ((PatternProviderMenu)((Object)menu)).getPatternBox().getName()));
        }
        this.showInPatternAccessTerminalButton = new ToggleButton(Icon.PATTERN_ACCESS_SHOW, Icon.PATTERN_ACCESS_HIDE, (Component)GuiText.PatternAccessTerminal.text(), (Component)GuiText.PatternAccessTerminalHint.text(), btn -> this.selectNextPatternProviderMode());
        this.addToLeftToolbar(this.showInPatternAccessTerminalButton);
        this.lockReason = new PatternProviderLockReason(this);
        this.widgets.add("lockReason", this.lockReason);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.lockReason.setVisible(((PatternProviderMenu)this.f_97732_).getLockCraftingMode() != LockCraftingMode.NONE);
        this.blockingModeButton.set(((PatternProviderMenu)this.f_97732_).getBlockingMode());
        this.extraBlockingModeButton.set(((PatternProviderMenu)this.f_97732_).getExtraBlockingMode());
        this.lockCraftingModeButton.set(((PatternProviderMenu)this.f_97732_).getLockCraftingMode());
        this.showInPatternAccessTerminalButton.setState(((PatternProviderMenu)this.f_97732_).getShowInAccessTerminal() == YesNo.YES);
    }

    private void selectNextPatternProviderMode() {
        boolean backwards = this.isHandlingRightClick();
        NetworkHandler.instance().sendToServer(new ConfigButtonPacket(Settings.PATTERN_ACCESS_TERMINAL, backwards));
    }

    private List<Component> getCompatibleUpgrades() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)GuiText.CompatibleUpgrades.text());
        list.addAll(Upgrades.getTooltipLinesForMachine(((PatternProviderMenu)this.f_97732_).getUpgrades().getUpgradableItem()));
        return list;
    }
}

