/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 AlgorithmX2
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package appeng.api.parts;

import net.minecraft.core.Direction;

public interface IPartCollisionHelper {

    /**
     * add a collision box, expects 0.0 - 16.0 block coords.
     *
     * No complaints about the size, I like using pixels :P
     *
     * @param minX minimal x collision
     * @param minY minimal y collision
     * @param minZ minimal z collision
     * @param maxX maximal x collision
     * @param maxY maximal y collision
     * @param maxZ maximal z collision
     */
    void addBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ);

    /**
     * @return east in world space.
     */
    Direction getWorldX();

    /**
     * @return up in world space.
     */
    Direction getWorldY();

    /**
     * @return forward in world space.
     */
    Direction getWorldZ();

    /**
     * @return true if this test is to get the BB Collision information.
     */
    boolean isBBCollision();
}
