/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.mattercannon;

import appeng.core.AppEng;
import appeng.recipes.AERecipeTypes;
import appeng.recipes.mattercannon.MatterCannonAmmoSerializer;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import org.jetbrains.annotations.Nullable;

public class MatterCannonAmmo
implements Recipe<Container> {
    public static final ResourceLocation TYPE_ID = AppEng.makeId("matter_cannon");
    public static final RecipeType<MatterCannonAmmo> TYPE = AERecipeTypes.MATTER_CANNON_AMMO;
    private final ResourceLocation id;
    private final Ingredient ammo;
    private final float weight;

    public MatterCannonAmmo(ResourceLocation id, Ingredient ammo, float weight) {
        Preconditions.checkArgument((weight >= 0.0f ? 1 : 0) != 0, (Object)"Weight must not be negative");
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.ammo = Objects.requireNonNull(ammo, "ammo must not be null");
        this.weight = weight;
    }

    public static void ammo(Consumer<FinishedRecipe> consumer, ResourceLocation id, ItemLike item, float weight) {
        consumer.accept(new Ammo(id, null, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), weight));
    }

    public static void ammo(Consumer<FinishedRecipe> consumer, ResourceLocation id, Ingredient ammo, float weight) {
        consumer.accept(new Ammo(id, null, ammo, weight));
    }

    public static void ammo(Consumer<FinishedRecipe> consumer, ResourceLocation id, TagKey<Item> tag, float weight) {
        consumer.accept(new Ammo(id, tag, null, weight));
    }

    public boolean m_5818_(Container inv, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return MatterCannonAmmoSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122779_();
    }

    public Ingredient getAmmo() {
        return this.ammo;
    }

    public float getWeight() {
        return this.weight;
    }

    public record Ammo(ResourceLocation id, TagKey<Item> tag, Ingredient nonTag, float weight) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            JsonArray conditions = new JsonArray();
            if (this.tag != null) {
                json.add("ammo", Ingredient.m_204132_(this.tag).m_43942_());
                conditions.add((JsonElement)CraftingHelper.serialize((ICondition)new NotCondition((ICondition)new TagEmptyCondition(this.tag.f_203868_()))));
            } else if (this.nonTag != null) {
                json.add("ammo", this.nonTag.m_43942_());
            }
            json.addProperty("weight", (Number)Float.valueOf(this.weight));
            json.add("conditions", (JsonElement)conditions);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return MatterCannonAmmoSerializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

