/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.config.CpuSelectionMode;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.client.render.BlockHighlightHandler;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.BlockHighlightPacket;
import appeng.core.sync.packets.CraftingStatusPacket;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.service.CraftingService;
import appeng.menu.AEBaseMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.me.crafting.CraftingStatus;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CraftingCPUMenu
extends AEBaseMenu {
    private static final String ACTION_CANCEL_CRAFTING = "cancelCrafting";
    public static final MenuType<CraftingCPUMenu> TYPE = MenuTypeBuilder.create(CraftingCPUMenu::new, CraftingBlockEntity.class).withMenuTitle(craftingBlockEntity -> {
        CraftingCPUCluster cluster = craftingBlockEntity.getCluster();
        if (cluster != null && cluster.getName() != null) {
            return cluster.getName();
        }
        return Component.m_237119_();
    }).build("craftingcpu");
    private final IncrementalUpdateHelper incrementalUpdateHelper = new IncrementalUpdateHelper();
    private final IGrid grid;
    private CraftingCPUCluster cpu = null;
    private final Consumer<AEKey> cpuChangeListener = this.incrementalUpdateHelper::addChange;
    @GuiSync(value=0)
    public CpuSelectionMode schedulingMode = CpuSelectionMode.ANY;
    @GuiSync(value=1)
    public boolean cantStoreItems = false;

    public CraftingCPUMenu(MenuType<?> menuType, int id, Inventory ip, Object te) {
        super(menuType, id, ip, te);
        IActionHost host = (IActionHost)(te instanceof IActionHost ? te : null);
        this.grid = host != null && host.getActionableNode() != null ? host.getActionableNode().getGrid() : null;
        if (te instanceof CraftingBlockEntity) {
            this.setCPU(((CraftingBlockEntity)te).getCluster());
        }
        if (this.getGrid() == null && this.isServerSide()) {
            this.setValidMenu(false);
        }
        this.registerClientAction(ACTION_CANCEL_CRAFTING, this::cancelCrafting);
    }

    protected void setCPU(ICraftingCPU c) {
        if (c == this.cpu) {
            return;
        }
        if (this.cpu != null) {
            this.cpu.craftingLogic.removeListener(this.cpuChangeListener);
        }
        this.incrementalUpdateHelper.reset();
        if (c instanceof CraftingCPUCluster) {
            this.cpu = (CraftingCPUCluster)c;
            KeyCounter allItems = new KeyCounter();
            this.cpu.craftingLogic.getAllItems(allItems);
            for (Object2LongMap.Entry<AEKey> entry : allItems) {
                this.incrementalUpdateHelper.addChange((AEKey)entry.getKey());
            }
            this.cpu.craftingLogic.addListener(this.cpuChangeListener);
        } else {
            this.cpu = null;
            this.sendPacketToClient(new CraftingStatusPacket(this.f_38840_, CraftingStatus.EMPTY));
        }
    }

    public void cancelCrafting() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CANCEL_CRAFTING);
        } else if (this.cpu != null) {
            this.cpu.cancelJob();
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.cpu != null) {
            this.cpu.craftingLogic.removeListener(this.cpuChangeListener);
        }
    }

    @Override
    public void m_38946_() {
        if (this.isServerSide() && this.cpu != null) {
            this.schedulingMode = this.cpu.getSelectionMode();
            this.cantStoreItems = this.cpu.craftingLogic.isCantStoreItems();
            if (this.incrementalUpdateHelper.hasChanges()) {
                CraftingStatus status = CraftingStatus.create(this.incrementalUpdateHelper, this.cpu.craftingLogic);
                this.incrementalUpdateHelper.commitChanges();
                this.sendPacketToClient(new CraftingStatusPacket(this.f_38840_, status));
            }
        }
        super.m_38946_();
    }

    public CpuSelectionMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public boolean isCantStoreItems() {
        return this.cantStoreItems;
    }

    public boolean allowConfiguration() {
        return true;
    }

    IGrid getGrid() {
        return this.grid;
    }

    public void highlight(AEKey what) {
        if (this.isServerSide() && this.grid != null) {
            CraftingService service = (CraftingService)this.grid.getCraftingService();
            Collection<IPatternDetails> patterns = service.getCraftingFor(what);
            HashSet<BlockEntity> bePositions = new HashSet<BlockEntity>();
            for (IPatternDetails pattern : patterns) {
                Iterable<ICraftingProvider> provider = service.getProviders(pattern);
                for (ICraftingProvider providerPos : provider) {
                    if (!(providerPos instanceof PatternProviderLogic)) continue;
                    PatternProviderLogic host = (PatternProviderLogic)providerPos;
                    BlockEntity be = host.host.getBlockEntity();
                    if (be == null) continue;
                    bePositions.add(be);
                }
            }
            if (!bePositions.isEmpty()) {
                for (BlockEntity pos : bePositions) {
                    PatternProviderBlockEntity ppBe = (PatternProviderBlockEntity)pos;
                    BlockHighlightPacket packet = new BlockHighlightPacket(ppBe.m_58899_(), (ResourceKey<Level>)ppBe.m_58904_().m_46472_(), BlockHighlightHandler.getTime(ppBe.m_58899_(), this.getPlayer().m_20097_()));
                    NetworkHandler.instance().sendTo(packet, (ServerPlayer)this.getPlayer());
                }
            }
        }
    }
}

