/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.service;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.events.GridBootingStatusChange;
import appeng.api.networking.spatial.ISpatialService;
import appeng.blockentity.spatial.SpatialIOPortBlockEntity;
import appeng.blockentity.spatial.SpatialPylonBlockEntity;
import appeng.core.AEConfig;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class SpatialPylonService
implements ISpatialService,
IGridServiceProvider {
    private final IGrid myGrid;
    private long powerRequired = 0L;
    private double efficiency = 0.0;
    private ServerLevel captureLevel;
    private BlockPos captureMin;
    private BlockPos captureMax;
    private boolean isValid = false;
    private List<SpatialIOPortBlockEntity> ioPorts = new ArrayList<SpatialIOPortBlockEntity>();
    private HashMap<SpatialPylonCluster, SpatialPylonCluster> clusters = new HashMap();

    public SpatialPylonService(IGrid g) {
        this.myGrid = g;
    }

    public void bootingRender(GridBootingStatusChange c) {
        this.reset(this.myGrid);
    }

    private void reset(IGrid grid) {
        this.clusters = new HashMap();
        this.ioPorts = new ArrayList<SpatialIOPortBlockEntity>();
        for (IGridNode gm : grid.getMachineNodes(SpatialIOPortBlockEntity.class)) {
            this.ioPorts.add((SpatialIOPortBlockEntity)gm.getOwner());
        }
        for (IGridNode gm : grid.getMachineNodes(SpatialPylonBlockEntity.class)) {
            SpatialPylonCluster c;
            if (!gm.meetsChannelRequirements() || (c = ((SpatialPylonBlockEntity)gm.getOwner()).getCluster()) == null) continue;
            this.clusters.put(c, c);
        }
        this.captureLevel = null;
        this.isValid = true;
        BlockPos.MutableBlockPos minPoint = null;
        BlockPos.MutableBlockPos maxPoint = null;
        int pylonBlocks = 0;
        for (SpatialPylonCluster cl : this.clusters.values()) {
            if (this.captureLevel == null) {
                this.captureLevel = cl.setLevel();
            } else if (this.captureLevel != cl.setLevel()) continue;
            if (maxPoint == null) {
                maxPoint = cl.getBoundsMax().m_122032_();
            } else {
                maxPoint.m_142451_(Math.max(maxPoint.m_123341_(), cl.getBoundsMax().m_123341_()));
                maxPoint.m_142448_(Math.max(maxPoint.m_123342_(), cl.getBoundsMax().m_123342_()));
                maxPoint.m_142443_(Math.max(maxPoint.m_123343_(), cl.getBoundsMax().m_123343_()));
            }
            if (minPoint == null) {
                minPoint = cl.getBoundsMin().m_122032_();
            } else {
                minPoint.m_142451_(Math.min(minPoint.m_123341_(), cl.getBoundsMin().m_123341_()));
                minPoint.m_142448_(Math.min(minPoint.m_123342_(), cl.getBoundsMin().m_123342_()));
                minPoint.m_142443_(Math.min(minPoint.m_123343_(), cl.getBoundsMin().m_123343_()));
            }
            pylonBlocks += cl.size();
        }
        this.captureMin = minPoint != null ? minPoint.m_7949_() : null;
        this.captureMax = maxPoint != null ? maxPoint.m_7949_() : null;
        double minPower = 0.0;
        if (this.hasRegion()) {
            this.isValid = this.captureMax.m_123341_() - this.captureMin.m_123341_() > 1 && this.captureMax.m_123342_() - this.captureMin.m_123342_() > 1 && this.captureMax.m_123343_() - this.captureMin.m_123343_() > 1;
            for (SpatialPylonCluster cl : this.clusters.values()) {
                switch (cl.getCurrentAxis()) {
                    case X: {
                        this.isValid = !(!this.isValid || this.captureMax.m_123342_() != cl.getBoundsMin().m_123342_() && this.captureMin.m_123342_() != cl.getBoundsMax().m_123342_() && this.captureMax.m_123343_() != cl.getBoundsMin().m_123343_() && this.captureMin.m_123343_() != cl.getBoundsMax().m_123343_() || this.captureMax.m_123342_() != cl.getBoundsMax().m_123342_() && this.captureMin.m_123342_() != cl.getBoundsMin().m_123342_() && this.captureMax.m_123343_() != cl.getBoundsMax().m_123343_() && this.captureMin.m_123343_() != cl.getBoundsMin().m_123343_());
                        break;
                    }
                    case Y: {
                        this.isValid = !(!this.isValid || this.captureMax.m_123341_() != cl.getBoundsMin().m_123341_() && this.captureMin.m_123341_() != cl.getBoundsMax().m_123341_() && this.captureMax.m_123343_() != cl.getBoundsMin().m_123343_() && this.captureMin.m_123343_() != cl.getBoundsMax().m_123343_() || this.captureMax.m_123341_() != cl.getBoundsMax().m_123341_() && this.captureMin.m_123341_() != cl.getBoundsMin().m_123341_() && this.captureMax.m_123343_() != cl.getBoundsMax().m_123343_() && this.captureMin.m_123343_() != cl.getBoundsMin().m_123343_());
                        break;
                    }
                    case Z: {
                        this.isValid = !(!this.isValid || this.captureMax.m_123342_() != cl.getBoundsMin().m_123342_() && this.captureMin.m_123342_() != cl.getBoundsMax().m_123342_() && this.captureMax.m_123341_() != cl.getBoundsMin().m_123341_() && this.captureMin.m_123341_() != cl.getBoundsMax().m_123341_() || this.captureMax.m_123342_() != cl.getBoundsMax().m_123342_() && this.captureMin.m_123342_() != cl.getBoundsMin().m_123342_() && this.captureMax.m_123341_() != cl.getBoundsMax().m_123341_() && this.captureMin.m_123341_() != cl.getBoundsMin().m_123341_());
                        break;
                    }
                    case UNFORMED: {
                        this.isValid = false;
                    }
                }
            }
            int reqX = this.captureMax.m_123341_() - this.captureMin.m_123341_();
            int reqY = this.captureMax.m_123342_() - this.captureMin.m_123342_();
            int reqZ = this.captureMax.m_123343_() - this.captureMin.m_123343_();
            int requirePylonBlocks = Math.max(6, (reqX * reqZ + reqX * reqY + reqY * reqZ) * 3 / 8);
            this.efficiency = (double)pylonBlocks / (double)requirePylonBlocks;
            if (this.efficiency > 1.0) {
                this.efficiency = 1.0;
            }
            if (this.efficiency < 0.0) {
                this.efficiency = 0.0;
            }
            minPower = (double)reqX * (double)reqY * (double)reqZ * AEConfig.instance().getSpatialPowerMultiplier();
        }
        this.powerRequired = (long)Math.pow(minPower, 1.0 + (AEConfig.instance().getSpatialPowerExponent() - 1.0) * (1.0 - this.efficiency));
        for (SpatialPylonCluster cl : this.clusters.values()) {
            boolean myWasValid = cl.isValid();
            cl.setValid(this.isValid);
            if (myWasValid == this.isValid) continue;
            cl.updateStatus(false);
        }
    }

    @Override
    public boolean hasRegion() {
        return this.captureLevel != null && this.captureMin != null && this.captureMax != null;
    }

    @Override
    public boolean isValidRegion() {
        return this.hasRegion() && this.isValid;
    }

    public ServerLevel getLevel() {
        return this.captureLevel;
    }

    @Override
    public BlockPos getMin() {
        return this.captureMin;
    }

    @Override
    public BlockPos getMax() {
        return this.captureMax;
    }

    @Override
    public long requiredPower() {
        return this.powerRequired;
    }

    @Override
    public float currentEfficiency() {
        return (float)this.efficiency * 100.0f;
    }

    static {
        GridHelper.addGridServiceEventHandler(GridBootingStatusChange.class, ISpatialService.class, (service, evt) -> ((SpatialPylonService)service).bootingRender((GridBootingStatusChange)evt));
    }
}

