/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.menu.me.crafting.CraftAmountMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ConfirmAutoCraftPacket
extends BasePacket {
    private final int amount;
    private final boolean craftMissingAmount;
    private final boolean autoStart;

    public ConfirmAutoCraftPacket(FriendlyByteBuf stream) {
        this.autoStart = stream.readBoolean();
        this.craftMissingAmount = stream.readBoolean();
        this.amount = stream.readInt();
    }

    public ConfirmAutoCraftPacket(int craftAmt, boolean craftMissingAmount, boolean autoStart) {
        this.amount = craftAmt;
        this.craftMissingAmount = craftMissingAmount;
        this.autoStart = autoStart;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(autoStart);
        data.writeBoolean(craftMissingAmount);
        data.writeInt(this.amount);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof CraftAmountMenu) {
            CraftAmountMenu menu = (CraftAmountMenu)abstractContainerMenu;
            menu.confirm(this.amount, this.craftMissingAmount, this.autoStart);
        }
    }
}

