/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import appeng.core.AELog;
import appeng.crafting.pattern.AEStonecuttingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.StonecuttingPatternEncoding;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StonecuttingPatternItem
extends EncodedPatternItem {
    public StonecuttingPatternItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public AEStonecuttingPattern decode(ItemStack stack, Level level, boolean tryRecovery) {
        CompoundTag tag;
        if (stack.m_41720_() != this || !stack.m_41782_() || level == null) {
            return null;
        }
        AEStonecuttingPattern result = this.decode(AEItemKey.of(stack), level);
        if (tryRecovery && result == null && this.attemptRecovery(tag = stack.m_41784_(), level)) {
            result = this.decode(stack, level, false);
        }
        return result;
    }

    @Override
    public AEStonecuttingPattern decode(AEItemKey what, Level level) {
        if (what == null || !what.hasTag()) {
            return null;
        }
        try {
            return new AEStonecuttingPattern(what, level);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack encode(StonecutterRecipe recipe, AEItemKey in, AEItemKey out, boolean allowSubstitutes, String author) {
        ItemStack stack = new ItemStack((ItemLike)this);
        StonecuttingPatternEncoding.encode(stack.m_41784_(), recipe, in, out, allowSubstitutes, author);
        return stack;
    }

    private boolean attemptRecovery(CompoundTag tag, Level level) {
        RecipeManager recipeManager = level.m_7465_();
        AEItemKey input = StonecuttingPatternEncoding.getInput(tag);
        AEItemKey output = StonecuttingPatternEncoding.getOutput(tag);
        String author = StonecuttingPatternEncoding.getAuthor(tag);
        if (input == null || output == null) {
            return false;
        }
        ResourceLocation recipeId = StonecuttingPatternEncoding.getRecipeId(tag);
        SimpleContainer testInventory = new SimpleContainer(1);
        testInventory.m_6836_(0, input.toStack());
        List potentialRecipes = recipeManager.m_44056_(RecipeType.f_44112_, (Container)testInventory, level);
        for (StonecutterRecipe potentialRecipe : potentialRecipes) {
            if (!AEItemKey.matches(output, potentialRecipe.m_8043_(level.m_9598_()))) continue;
            AELog.debug("Re-Encoding pattern from %s -> %s", recipeId, potentialRecipe.m_6423_());
            StonecuttingPatternEncoding.encode(tag, potentialRecipe, input, output, StonecuttingPatternEncoding.canSubstitute(tag), author);
        }
        AELog.info("Failed to recover encoded stonecutting pattern for recipe %s", recipeId);
        return false;
    }
}

