/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.crafting.pattern.AEPatternHelper;
import appeng.crafting.pattern.CraftingPatternEncoding;
import appeng.menu.AutoCraftingMenu;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AECraftingPattern
implements IPatternDetails,
IMolecularAssemblerSupportedPattern {
    public static final int CRAFTING_GRID_DIMENSION = 3;
    public static final int CRAFTING_GRID_SLOTS = 9;
    private final AEItemKey definition;
    public final boolean canSubstitute;
    public final boolean canSubstituteFluids;
    private final String author;
    private final CraftingRecipe recipe;
    private final CraftingContainer testFrame;
    private final CraftingContainer specialRecipeTestFrame;
    private final GenericStack[] sparseInputs;
    private final int[] sparseToCompressed = new int[9];
    private final Input[] inputs;
    private final ItemStack output;
    private final GenericStack[] outputsArray;
    private final Map<Item, Boolean>[] isValidCache = new Map[9];

    public AECraftingPattern(AEItemKey definition, Level level) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.canSubstitute = CraftingPatternEncoding.canSubstitute(tag);
        this.canSubstituteFluids = CraftingPatternEncoding.canSubstituteFluids(tag);
        this.sparseInputs = CraftingPatternEncoding.getCraftingInputs(tag);
        this.author = CraftingPatternEncoding.getAuthor(tag);
        ResourceLocation recipeId = CraftingPatternEncoding.getRecipeId(tag);
        this.recipe = (CraftingRecipe)level.m_7465_().m_44054_(RecipeType.f_44107_).get(recipeId);
        this.testFrame = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
        this.specialRecipeTestFrame = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            if (this.sparseInputs[i] == null) continue;
            AEItemKey itemKey = (AEItemKey)this.sparseInputs[i].what();
            this.testFrame.m_6836_(i, itemKey.toStack());
        }
        if (!this.recipe.m_5818_((Container)this.testFrame, level)) {
            throw new IllegalStateException("The recipe " + this.recipe + " no longer matches the encoded input.");
        }
        this.output = this.recipe.m_5874_((Container)this.testFrame, level.m_9598_());
        if (this.output.m_41619_()) {
            throw new IllegalStateException("The recipe " + recipeId + " produced an empty item stack result.");
        }
        this.outputsArray = new GenericStack[]{Objects.requireNonNull(GenericStack.fromItemStack(this.output))};
        GenericStack[] condensedInputs = AEPatternHelper.condenseStacks(this.sparseInputs);
        this.inputs = new Input[condensedInputs.length];
        for (int i = 0; i < 9; ++i) {
            this.sparseToCompressed[i] = -1;
        }
        for (int j = 0; j < condensedInputs.length; ++j) {
            GenericStack condensedInput = condensedInputs[j];
            for (int i = 0; i < 9; ++i) {
                if (this.sparseInputs[i] == null || !this.sparseInputs[i].what().equals(condensedInput.what())) continue;
                if (this.inputs[j] == null) {
                    this.inputs[j] = new Input(i, condensedInput);
                }
                this.sparseToCompressed[i] = j;
            }
        }
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AECraftingPattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.outputsArray;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    private Ingredient getRecipeIngredient(int slot) {
        CraftingRecipe craftingRecipe = this.recipe;
        if (craftingRecipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
            return this.getShapedRecipeIngredient(slot, shapedRecipe.m_44220_());
        }
        return this.getShapelessRecipeIngredient(slot);
    }

    private Ingredient getShapedRecipeIngredient(int slot, int recipeWidth) {
        int topOffset = 0;
        if (this.sparseInputs[0] == null && this.sparseInputs[1] == null && this.sparseInputs[2] == null) {
            ++topOffset;
            if (this.sparseInputs[3] == null && this.sparseInputs[4] == null && this.sparseInputs[5] == null) {
                ++topOffset;
            }
        }
        int leftOffset = 0;
        if (this.sparseInputs[0] == null && this.sparseInputs[3] == null && this.sparseInputs[6] == null) {
            ++leftOffset;
            if (this.sparseInputs[1] == null && this.sparseInputs[4] == null && this.sparseInputs[7] == null) {
                ++leftOffset;
            }
        }
        int slotX = slot % 3 - leftOffset;
        int slotY = slot / 3 - topOffset;
        int ingredientIndex = slotY * recipeWidth + slotX;
        NonNullList ingredients = this.recipe.m_7527_();
        if (ingredientIndex < 0 || ingredientIndex > ingredients.size()) {
            return Ingredient.f_43901_;
        }
        return (Ingredient)ingredients.get(ingredientIndex);
    }

    private Ingredient getShapelessRecipeIngredient(int slot) {
        int ingredientIndex = 0;
        for (int i = 0; i < slot; ++i) {
            if (this.sparseInputs[i] == null) continue;
            ++ingredientIndex;
        }
        NonNullList ingredients = this.recipe.m_7527_();
        if (ingredientIndex < ingredients.size()) {
            return (Ingredient)ingredients.get(ingredientIndex);
        }
        return Ingredient.f_43901_;
    }

    @Nullable
    public GenericStack getValidFluid(int slot) {
        GenericStack itemOrFluid;
        int compressed = this.sparseToCompressed[slot];
        if (compressed != -1 && (itemOrFluid = this.inputs[compressed].possibleInputs[0]).what() instanceof AEFluidKey) {
            return itemOrFluid;
        }
        return null;
    }

    @Override
    public boolean isItemValid(int slot, AEItemKey key, Level level) {
        if (!this.canSubstitute) {
            return this.sparseInputs[slot] == null && key == null || this.sparseInputs[slot] != null && this.sparseInputs[slot].what().equals(key);
        }
        if (key == null) {
            return this.sparseInputs[slot] == null;
        }
        Boolean result = this.getTestResult(slot, key);
        if (result != null) {
            return result;
        }
        ItemStack previousStack = this.testFrame.m_8016_(slot);
        this.testFrame.m_6836_(slot, key.toStack());
        boolean newResult = this.recipe.m_5818_((Container)this.testFrame, level) && ItemStack.m_41728_((ItemStack)this.output, (ItemStack)this.recipe.m_5874_((Container)this.testFrame, level.m_9598_()));
        this.setTestResult(slot, key, newResult);
        this.testFrame.m_6836_(slot, previousStack);
        return newResult;
    }

    @Override
    public boolean isSlotEnabled(int slot) {
        return this.sparseInputs[slot] != null;
    }

    private ItemStack getRecipeRemainder(int slot, AEItemKey key) {
        ItemStack previousStack = this.testFrame.m_8016_(slot);
        this.testFrame.m_6836_(slot, key.toStack());
        ItemStack remainder = (ItemStack)this.recipe.m_7457_((Container)this.testFrame).get(slot);
        this.testFrame.m_6836_(slot, previousStack);
        return remainder;
    }

    @Nullable
    private Boolean getTestResult(int slot, AEItemKey what) {
        if (what == null || what.hasTag()) {
            return null;
        }
        Map<Item, Boolean> cache = this.isValidCache[slot];
        if (cache == null) {
            return null;
        }
        return cache.get(what.getItem());
    }

    private void setTestResult(int slot, AEItemKey what, boolean result) {
        if (what != null && !what.hasTag()) {
            Map<Item, Boolean> cache = this.isValidCache[slot];
            if (cache == null) {
                cache = this.isValidCache[slot] = new IdentityHashMap<Item, Boolean>();
            }
            cache.put(what.getItem(), result);
        }
    }

    public GenericStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    public GenericStack[] getSparseOutputs() {
        return this.outputsArray;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    public boolean canSubstituteFluids() {
        return this.canSubstituteFluids;
    }

    private int getCompressedIndexFromSparse(int sparse) {
        return this.sparseToCompressed[sparse];
    }

    @Override
    public void fillCraftingGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern.CraftingGridAccessor gridAccessor) {
        block0: for (int sparseIndex = 0; sparseIndex < 9; ++sparseIndex) {
            int requiredAmount;
            AEKey validFluidKey;
            long amount;
            int inputId = this.getCompressedIndexFromSparse(sparseIndex);
            if (inputId == -1) continue;
            KeyCounter list = table[inputId];
            GenericStack validFluid = this.getValidFluid(sparseIndex);
            if (validFluid != null && (amount = list.get(validFluidKey = validFluid.what())) >= (long)(requiredAmount = (int)validFluid.amount())) {
                gridAccessor.set(sparseIndex, GenericStack.wrapInItemStack(validFluidKey, requiredAmount));
                list.remove(validFluidKey, requiredAmount);
                continue;
            }
            for (Object2LongMap.Entry<AEKey> entry : list) {
                Object object;
                if (entry.getLongValue() <= 0L || !((object = entry.getKey()) instanceof AEItemKey)) continue;
                AEItemKey itemKey = (AEItemKey)object;
                gridAccessor.set(sparseIndex, itemKey.toStack());
                list.remove(itemKey, 1L);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack assemble(Container container, Level level) {
        if (this.canSubstitute && this.recipe.m_5598_()) {
            this.specialRecipeTestFrame.m_6211_();
            for (int x = 0; x < container.m_6643_(); ++x) {
                GenericStack validFluid;
                ItemStack item = container.m_8020_(x);
                GenericStack stack = GenericStack.unwrapItemStack(item);
                if (stack != null && (validFluid = this.getValidFluid(x)) != null && validFluid.equals(stack)) {
                    this.specialRecipeTestFrame.m_6836_(x, ((AEItemKey)this.sparseInputs[x].what()).toStack());
                    continue;
                }
                this.specialRecipeTestFrame.m_6836_(x, item.m_41777_());
            }
            return this.recipe.m_5874_((Container)this.specialRecipeTestFrame, level.m_9598_());
        }
        for (int x = 0; x < container.m_6643_(); ++x) {
            GenericStack validFluid;
            ItemStack item = container.m_8020_(x);
            GenericStack stack = GenericStack.unwrapItemStack(item);
            if (stack != null && (validFluid = this.getValidFluid(x)) != null && validFluid.equals(stack) || this.isItemValid(x, AEItemKey.of(item), level)) continue;
            return ItemStack.f_41583_;
        }
        return this.output;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        if (this.canSubstituteFluids) {
            boolean[] slotsToClear = new boolean[container.m_6643_()];
            for (int x = 0; x < container.m_6643_(); ++x) {
                ItemStack item;
                GenericStack stack;
                GenericStack validFluid = this.getValidFluid(x);
                if (validFluid == null || !validFluid.equals(stack = GenericStack.unwrapItemStack(item = container.m_8020_(x)))) continue;
                container.m_6836_(x, ((AEItemKey)this.sparseInputs[x].what()).toStack());
                slotsToClear[x] = true;
            }
            NonNullList result = this.recipe.m_7457_((Container)container);
            for (int i = 0; i < slotsToClear.length; ++i) {
                if (!slotsToClear[i]) continue;
                result.set(i, (Object)ItemStack.f_41583_);
            }
            return result;
        }
        return this.recipe.m_7457_((Container)container);
    }

    private GenericStack getItemOrFluidInput(int slot, GenericStack item) {
        boolean isBucket;
        AEKey aEKey = item.what();
        if (!(aEKey instanceof AEItemKey)) {
            return item;
        }
        AEItemKey itemKey = (AEItemKey)aEKey;
        GenericStack containedFluid = ContainerItemStrategies.getContainedStack(itemKey.toStack(), AEKeyType.fluids());
        boolean bl = isBucket = itemKey.getItem() instanceof BucketItem || itemKey.getItem() instanceof MilkBucketItem;
        if (this.canSubstituteFluids && containedFluid != null && isBucket) {
            TransientCraftingContainer testFrameCopy = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
            for (int i = 0; i < 9; ++i) {
                testFrameCopy.m_6836_(i, this.testFrame.m_8020_(i).m_41777_());
            }
            NonNullList remainingItems = this.recipe.m_7457_((Container)testFrameCopy);
            ItemStack slotRemainder = (ItemStack)remainingItems.get(slot);
            if (slotRemainder.m_41613_() == 1 && slotRemainder.m_150930_(Items.f_42446_)) {
                return new GenericStack(containedFluid.what(), containedFluid.amount());
            }
        }
        return item;
    }

    private class Input
    implements IPatternDetails.IInput {
        private final int slot;
        private final GenericStack[] possibleInputs;
        private final long multiplier;

        private Input(int slot, GenericStack condensedInput) {
            this.slot = slot;
            this.multiplier = condensedInput.amount();
            GenericStack itemOrFluidInput = AECraftingPattern.this.getItemOrFluidInput(slot, AECraftingPattern.this.sparseInputs[slot]);
            if (!AECraftingPattern.this.canSubstitute) {
                this.possibleInputs = new GenericStack[]{itemOrFluidInput};
            } else {
                ItemStack[] matchingStacks = AECraftingPattern.this.getRecipeIngredient(slot).m_43908_();
                this.possibleInputs = new GenericStack[matchingStacks.length + 1];
                this.possibleInputs[0] = itemOrFluidInput;
                for (int i = 0; i < matchingStacks.length; ++i) {
                    this.possibleInputs[i + 1] = GenericStack.fromItemStack(matchingStacks[i]);
                }
            }
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.possibleInputs;
        }

        @Override
        public long getMultiplier() {
            return this.multiplier;
        }

        @Override
        public boolean isValid(AEKey input, Level level) {
            if (input.matches(this.possibleInputs[0])) {
                return true;
            }
            if (AECraftingPattern.this.canSubstitute() && input instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)input;
                return AECraftingPattern.this.isItemValid(this.slot, itemKey, level);
            }
            return false;
        }

        @Override
        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            if (template instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)template;
                return AEItemKey.of(AECraftingPattern.this.getRecipeRemainder(this.slot, itemKey));
            }
            return null;
        }
    }
}

