/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.menu.me.crafting.CraftAmountMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ConfirmAutoCraftPacket
extends BasePacket {
    private final long amount;
    private final boolean craftMissingAmount;
    private final boolean autoStart;
    private final boolean isFollowing;

    public ConfirmAutoCraftPacket(FriendlyByteBuf stream) {
        this.autoStart = stream.readBoolean();
        this.craftMissingAmount = stream.readBoolean();
        this.amount = stream.readLong();
        this.isFollowing = stream.readBoolean();
    }

    public ConfirmAutoCraftPacket(long craftAmt, boolean craftMissingAmount, boolean autoStart, boolean isFollowing) {
        this.amount = craftAmt;
        this.craftMissingAmount = craftMissingAmount;
        this.autoStart = autoStart;
        this.isFollowing = isFollowing;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(autoStart);
        data.writeBoolean(craftMissingAmount);
        data.writeLong(this.amount);
        data.writeBoolean(isFollowing);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof CraftAmountMenu) {
            CraftAmountMenu menu = (CraftAmountMenu)abstractContainerMenu;
            menu.confirm(this.amount, this.craftMissingAmount, this.autoStart, this.isFollowing);
        }
    }
}

