/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.CondenserOutput;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.networking.pathing.ChannelMode;
import appeng.core.AELog;
import appeng.core.config.BooleanOption;
import appeng.core.config.ConfigFileManager;
import appeng.core.config.ConfigSection;
import appeng.core.config.ConfigValidationException;
import appeng.core.config.DoubleOption;
import appeng.core.config.EnumOption;
import appeng.core.config.IntegerOption;
import appeng.core.settings.TickRates;
import appeng.util.EnumCycler;
import appeng.util.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;

public final class AEConfig {
    public static final String CLIENT_CONFIG_PATH = "ae2/client.json";
    public static final String COMMON_CONFIG_PATH = "ae2/common.json";
    public final ClientConfig CLIENT;
    public final ConfigFileManager clientConfigManager;
    public final CommonConfig COMMON;
    public final ConfigFileManager commonConfigManager;
    private static final double DEFAULT_FE_EXCHANGE = 0.5;
    private static AEConfig instance;
    private int formationPlaneEntityLimit;
    private boolean enableEffects;
    private boolean useLargeFonts;
    private boolean useColoredCraftingStatus;
    private boolean disableColoredCableRecipesInJEI;
    private boolean isEnableFacadesInJEI;
    private boolean isEnableFacadeRecipesInJEI;
    private int craftingCalculationTimePerTick;
    private boolean craftingSimulatedExtraction;
    private boolean spatialAnchorEnablesRandomTicks;
    private double spatialPowerExponent;
    private double spatialPowerMultiplier;
    private int wirelessTerminalBattery;
    private int entropyManipulatorBattery;
    private int matterCannonBattery;
    private int portableCellBattery;
    private int colorApplicatorBattery;
    private int chargedStaffBattery;
    private double wirelessBaseCost;
    private double wirelessCostMultiplier;
    private double wirelessTerminalDrainMultiplier;
    private double wirelessBaseRange;
    private double wirelessBoosterRangeMultiplier;
    private double wirelessBoosterExp;
    private double wirelessHighWirelessCount;

    AEConfig(Path configDir) {
        ConfigSection clientRoot = ConfigSection.createRoot();
        this.CLIENT = new ClientConfig(clientRoot);
        this.clientConfigManager = configDir != null ? AEConfig.createConfigFileManager(clientRoot, configDir, CLIENT_CONFIG_PATH) : null;
        ConfigSection commonRoot = ConfigSection.createRoot();
        this.COMMON = new CommonConfig(commonRoot);
        this.commonConfigManager = configDir != null ? AEConfig.createConfigFileManager(commonRoot, configDir, COMMON_CONFIG_PATH) : null;
        this.syncClientConfig();
        this.syncCommonConfig();
    }

    private static ConfigFileManager createConfigFileManager(ConfigSection commonRoot, Path configDir, String filename) {
        Path configFile = configDir.resolve(filename);
        ConfigFileManager result = new ConfigFileManager(commonRoot, configFile);
        if (!Files.exists(configFile, new LinkOption[0])) {
            result.save();
        } else {
            try {
                result.load();
            }
            catch (ConfigValidationException e) {
                AELog.error("Failed to load AE2 Config. Making backup", e);
                AEConfig.makeBackupAndReset(configDir, filename);
            }
            try {
                result.save();
            }
            catch (Exception e) {
                AELog.warn(e);
            }
        }
        return result;
    }

    public static void load(Path configFolder) {
        if (instance != null) {
            throw new IllegalStateException("Config is already loaded");
        }
        instance = new AEConfig(configFolder);
    }

    private static void makeBackupAndReset(Path configFolder, String configFile) {
        Path backupFile = configFolder.resolve(configFile + ".bak");
        Path originalFile = configFolder.resolve(configFile);
        try {
            Files.move(originalFile, backupFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            AELog.warn("Failed to backup config file %s: %s!", originalFile, e);
        }
    }

    public double getP2PTunnelEnergyTax() {
        return this.COMMON.p2pTunnelEnergyTax.get();
    }

    public double getP2PTunnelTransportTax() {
        return this.COMMON.p2pTunnelTransportTax.get();
    }

    private void syncClientConfig() {
        this.disableColoredCableRecipesInJEI = this.CLIENT.disableColoredCableRecipesInJEI.get();
        this.isEnableFacadesInJEI = this.CLIENT.enableFacadesInJEI.get();
        this.isEnableFacadeRecipesInJEI = this.CLIENT.enableFacadeRecipesInJEI.get();
        this.enableEffects = this.CLIENT.enableEffects.get();
        this.useLargeFonts = this.CLIENT.useLargeFonts.get();
        this.useColoredCraftingStatus = this.CLIENT.useColoredCraftingStatus.get();
    }

    private void syncCommonConfig() {
        PowerUnits.FE.conversionRatio = this.COMMON.powerRatioForgeEnergy.get();
        PowerUnits.RF.conversionRatio = this.COMMON.powerRatioForgeEnergy.get();
        PowerMultiplier.CONFIG.multiplier = this.COMMON.powerUsageMultiplier.get();
        CondenserOutput.MATTER_BALLS.requiredPower = this.COMMON.condenserMatterBallsPower.get();
        CondenserOutput.SINGULARITY.requiredPower = this.COMMON.condenserSingularityPower.get();
        this.wirelessBaseCost = this.COMMON.wirelessBaseCost.get();
        this.wirelessCostMultiplier = this.COMMON.wirelessCostMultiplier.get();
        this.wirelessBaseRange = this.COMMON.wirelessBaseRange.get();
        this.wirelessBoosterRangeMultiplier = this.COMMON.wirelessBoosterRangeMultiplier.get();
        this.wirelessBoosterExp = this.COMMON.wirelessBoosterExp.get();
        this.wirelessHighWirelessCount = this.COMMON.wirelessHighWirelessCount.get();
        this.wirelessTerminalDrainMultiplier = this.COMMON.wirelessTerminalDrainMultiplier.get();
        this.formationPlaneEntityLimit = this.COMMON.formationPlaneEntityLimit.get();
        this.wirelessTerminalBattery = this.COMMON.wirelessTerminalBattery.get();
        this.chargedStaffBattery = this.COMMON.chargedStaffBattery.get();
        this.entropyManipulatorBattery = this.COMMON.entropyManipulatorBattery.get();
        this.portableCellBattery = this.COMMON.portableCellBattery.get();
        this.colorApplicatorBattery = this.COMMON.colorApplicatorBattery.get();
        this.matterCannonBattery = this.COMMON.matterCannonBattery.get();
        for (TickRates tr : TickRates.values()) {
            tr.setMin(this.COMMON.tickRateMin.get((Object)tr).get());
            tr.setMax(this.COMMON.tickRateMax.get((Object)tr).get());
        }
        this.spatialPowerMultiplier = this.COMMON.spatialPowerMultiplier.get();
        this.spatialPowerExponent = this.COMMON.spatialPowerExponent.get();
        this.craftingCalculationTimePerTick = this.COMMON.craftingCalculationTimePerTick.get();
        this.craftingSimulatedExtraction = this.COMMON.craftingSimulatedExtraction.get();
        this.spatialAnchorEnablesRandomTicks = this.COMMON.spatialAnchorEnableRandomTicks.get();
        AELog.setCraftingLogEnabled(this.COMMON.craftingLog.get());
        AELog.setDebugLogEnabled(this.COMMON.debugLog.get());
        AELog.setGridLogEnabled(this.COMMON.gridLog.get());
    }

    public static AEConfig instance() {
        return instance;
    }

    public double wireless_getDrainRate(double range) {
        return this.wirelessTerminalDrainMultiplier * range;
    }

    public double wireless_getMaxRange(int boosters) {
        return this.wirelessBaseRange + this.wirelessBoosterRangeMultiplier * Math.pow(boosters, this.wirelessBoosterExp);
    }

    public double wireless_getPowerDrain(int boosters) {
        return this.wirelessBaseCost + this.wirelessCostMultiplier * Math.pow(boosters, 1.0 + (double)boosters / this.wirelessHighWirelessCount);
    }

    public boolean isSearchModNameInTooltips() {
        return this.CLIENT.searchModNameInTooltips.get();
    }

    public void setSearchModNameInTooltips(boolean enable) {
        this.CLIENT.searchModNameInTooltips.set(enable);
    }

    public boolean isUseExternalSearch() {
        return this.CLIENT.useExternalSearch.get();
    }

    public void setUseExternalSearch(boolean enable) {
        this.CLIENT.useExternalSearch.set(enable);
    }

    public boolean isClearExternalSearchOnOpen() {
        return this.CLIENT.clearExternalSearchOnOpen.get();
    }

    public void setClearExternalSearchOnOpen(boolean enable) {
        this.CLIENT.clearExternalSearchOnOpen.set(enable);
    }

    public boolean isRememberLastSearch() {
        return this.CLIENT.rememberLastSearch.get();
    }

    public void setRememberLastSearch(boolean enable) {
        this.CLIENT.rememberLastSearch.set(enable);
    }

    public boolean isAutoFocusSearch() {
        return this.CLIENT.autoFocusSearch.get();
    }

    public void setAutoFocusSearch(boolean enable) {
        this.CLIENT.autoFocusSearch.set(enable);
    }

    public boolean isSyncWithExternalSearch() {
        return this.CLIENT.syncWithExternalSearch.get();
    }

    public void setSyncWithExternalSearch(boolean enable) {
        this.CLIENT.syncWithExternalSearch.set(enable);
    }

    public TerminalStyle getTerminalStyle() {
        return this.CLIENT.terminalStyle.get();
    }

    public void setTerminalStyle(TerminalStyle setting) {
        this.CLIENT.terminalStyle.set(setting);
    }

    public boolean isGuideHotkeyEnabled() {
        return this.CLIENT.enableGuideHotkey.get();
    }

    public double getGridEnergyStoragePerNode() {
        return this.COMMON.gridEnergyStoragePerNode.get();
    }

    public double getCrystalResonanceGeneratorRate() {
        return this.COMMON.crystalResonanceGeneratorRate.get();
    }

    public void save() {
    }

    public void reload() {
        this.clientConfigManager.load();
        this.commonConfigManager.load();
        this.syncClientConfig();
        this.syncCommonConfig();
    }

    public PowerUnits getSelectedPowerUnit() {
        return this.CLIENT.selectedPowerUnit.get();
    }

    public void nextPowerUnit(boolean backwards) {
        PowerUnits selectedPowerUnit = EnumCycler.rotateEnum(this.getSelectedPowerUnit(), backwards, Settings.POWER_UNITS.getValues());
        this.CLIENT.selectedPowerUnit.set(selectedPowerUnit);
    }

    public boolean isBlockEntityFacadesEnabled() {
        return this.COMMON.allowBlockEntityFacades.get();
    }

    public boolean isDebugToolsEnabled() {
        return this.COMMON.debugTools.get();
    }

    public int getFormationPlaneEntityLimit() {
        return this.formationPlaneEntityLimit;
    }

    public boolean isEnableEffects() {
        return this.enableEffects;
    }

    public boolean isUseLargeFonts() {
        return this.useLargeFonts;
    }

    public boolean isUseColoredCraftingStatus() {
        return this.useColoredCraftingStatus;
    }

    public boolean isDisableColoredCableRecipesInJEI() {
        return this.disableColoredCableRecipesInJEI;
    }

    public boolean isEnableFacadesInJEI() {
        return this.isEnableFacadesInJEI;
    }

    public boolean isEnableFacadeRecipesInJEI() {
        return this.isEnableFacadeRecipesInJEI;
    }

    public int getCraftingCalculationTimePerTick() {
        return this.craftingCalculationTimePerTick;
    }

    public boolean isCraftingSimulatedExtraction() {
        return this.craftingSimulatedExtraction;
    }

    public boolean isSpatialAnchorEnablesRandomTicks() {
        return this.spatialAnchorEnablesRandomTicks;
    }

    public double getSpatialPowerExponent() {
        return this.spatialPowerExponent;
    }

    public double getSpatialPowerMultiplier() {
        return this.spatialPowerMultiplier;
    }

    public double getChargerChargeRate() {
        return this.COMMON.chargerChargeRate.get();
    }

    public DoubleSupplier getWirelessTerminalBattery() {
        return () -> this.wirelessTerminalBattery;
    }

    public DoubleSupplier getEntropyManipulatorBattery() {
        return () -> this.entropyManipulatorBattery;
    }

    public DoubleSupplier getMatterCannonBattery() {
        return () -> this.matterCannonBattery;
    }

    public DoubleSupplier getPortableCellBattery() {
        return () -> this.portableCellBattery;
    }

    public DoubleSupplier getColorApplicatorBattery() {
        return () -> this.colorApplicatorBattery;
    }

    public DoubleSupplier getChargedStaffBattery() {
        return () -> this.chargedStaffBattery;
    }

    public boolean isShowDebugGuiOverlays() {
        return this.CLIENT.debugGuiOverlays.get();
    }

    public void setShowDebugGuiOverlays(boolean enable) {
        this.CLIENT.debugGuiOverlays.set(enable);
    }

    public boolean isSpawnPressesInMeteoritesEnabled() {
        return this.COMMON.spawnPressesInMeteorites.get();
    }

    public boolean isSpawnFlawlessOnlyEnabled() {
        return this.COMMON.spawnFlawlessOnly.get();
    }

    public boolean isMatterCanonBlockDamageEnabled() {
        return this.COMMON.matterCannonBlockDamage.get();
    }

    public boolean isTinyTntBlockDamageEnabled() {
        return this.COMMON.tinyTntBlockDamage.get();
    }

    public boolean isDisassemblyCraftingEnabled() {
        return this.COMMON.disassemblyCrafting.get();
    }

    public int getGrowthAcceleratorSpeed() {
        return this.COMMON.growthAcceleratorSpeed.get();
    }

    public boolean isBlockUpdateLogEnabled() {
        return this.COMMON.blockUpdateLog.get();
    }

    public boolean isPacketLogEnabled() {
        return this.COMMON.packetLog.get();
    }

    public boolean isChunkLoggerTraceEnabled() {
        return this.COMMON.chunkLoggerTrace.get();
    }

    public ChannelMode getChannelMode() {
        return this.COMMON.channels.get();
    }

    public void setChannelModel(ChannelMode mode) {
        this.COMMON.channels.set(mode);
    }

    public boolean isPlacementPreviewEnabled() {
        return this.CLIENT.showPlacementPreview.get();
    }

    public boolean isPortableCellDisassemblyEnabled() {
        return this.COMMON.portableCellDisassembly.get();
    }

    public boolean isTooltipShowCellUpgrades() {
        return this.CLIENT.tooltipShowCellUpgrades.get();
    }

    public boolean isTooltipShowCellContent() {
        return this.CLIENT.tooltipShowCellContent.get();
    }

    public int getTooltipMaxCellContentShown() {
        return this.CLIENT.tooltipMaxCellContentShown.get();
    }

    public boolean isPinAutoCraftedItems() {
        return this.CLIENT.pinAutoCraftedItems.get();
    }

    public void setPinAutoCraftedItems(boolean enabled) {
        this.CLIENT.pinAutoCraftedItems.set(enabled);
    }

    public boolean isNotifyForFinishedCraftingJobs() {
        return this.CLIENT.notifyForFinishedCraftingJobs.get();
    }

    public void setNotifyForFinishedCraftingJobs(boolean enabled) {
        this.CLIENT.notifyForFinishedCraftingJobs.set(enabled);
    }

    public boolean isFancyPatternTooltips() {
        return this.CLIENT.fancyPatternTooltips.get();
    }

    public boolean isClearGridOnClose() {
        return this.CLIENT.clearGridOnClose.get();
    }

    public void setClearGridOnClose(boolean enabled) {
        this.CLIENT.clearGridOnClose.set(enabled);
    }

    public double getVibrationChamberBaseEnergyPerFuelTick() {
        return this.COMMON.vibrationChamberBaseEnergyPerFuelTick.get();
    }

    public int getVibrationChamberMinEnergyPerGameTick() {
        return this.COMMON.vibrationChamberMinEnergyPerTick.get();
    }

    public int getVibrationChamberMaxEnergyPerGameTick() {
        return this.COMMON.vibrationChamberMaxEnergyPerTick.get();
    }

    public int getTerminalMargin() {
        return this.CLIENT.terminalMargin.get();
    }

    private static class ClientConfig {
        public final BooleanOption enableEffects;
        public final BooleanOption useLargeFonts;
        public final BooleanOption useColoredCraftingStatus;
        public final BooleanOption disableColoredCableRecipesInJEI;
        public final BooleanOption enableFacadesInJEI;
        public final BooleanOption enableFacadeRecipesInJEI;
        public final EnumOption<PowerUnits> selectedPowerUnit;
        public final BooleanOption debugGuiOverlays;
        public final BooleanOption showPlacementPreview;
        public final BooleanOption notifyForFinishedCraftingJobs;
        public final BooleanOption fancyPatternTooltips;
        public final EnumOption<TerminalStyle> terminalStyle;
        public final BooleanOption pinAutoCraftedItems;
        public final BooleanOption clearGridOnClose;
        public final IntegerOption terminalMargin;
        public final BooleanOption searchModNameInTooltips;
        public final BooleanOption useExternalSearch;
        public final BooleanOption clearExternalSearchOnOpen;
        public final BooleanOption syncWithExternalSearch;
        public final BooleanOption rememberLastSearch;
        public final BooleanOption autoFocusSearch;
        public final BooleanOption tooltipShowCellUpgrades;
        public final BooleanOption tooltipShowCellContent;
        public final IntegerOption tooltipMaxCellContentShown;
        public final BooleanOption enableGuideHotkey;

        public ClientConfig(ConfigSection root) {
            ConfigSection client = root.subsection("client");
            this.disableColoredCableRecipesInJEI = client.addBoolean("disableColoredCableRecipesInJEI", true);
            this.enableFacadesInJEI = client.addBoolean("enableFacadesInJEI", true, "Show facades in JEI ingredient list");
            this.enableFacadeRecipesInJEI = client.addBoolean("enableFacadeRecipesInJEI", true, "Show facade recipes in JEI for supported blocks");
            this.enableEffects = client.addBoolean("enableEffects", true);
            this.useLargeFonts = client.addBoolean("useTerminalUseLargeFont", false);
            this.useColoredCraftingStatus = client.addBoolean("useColoredCraftingStatus", true);
            this.selectedPowerUnit = client.addEnum("PowerUnit", PowerUnits.AE, "Power unit shown in AE UIs");
            this.debugGuiOverlays = client.addBoolean("showDebugGuiOverlays", false, "Show debugging GUI overlays");
            this.showPlacementPreview = client.addBoolean("showPlacementPreview", true, "Show a preview of part and facade placement");
            this.notifyForFinishedCraftingJobs = client.addBoolean("notifyForFinishedCraftingJobs", true, "Show toast when long-running crafting jobs finish.");
            this.fancyPatternTooltips = client.addBoolean("fancyPatternTooltips", true, "Show fancy tooltips for encoded patterns.");
            ConfigSection terminals = root.subsection("terminals");
            this.terminalStyle = terminals.addEnum("terminalStyle", TerminalStyle.SMALL);
            this.pinAutoCraftedItems = terminals.addBoolean("pinAutoCraftedItems", true, "Pin items that the player auto-crafts to the top of the terminal");
            this.clearGridOnClose = client.addBoolean("clearGridOnClose", false, "Automatically clear the crafting/encoding grid when closing the terminal");
            this.terminalMargin = client.addInt("terminalMargin", 25, "The vertical margin to apply when sizing terminals. Used to make room for centered item mod search bars");
            ConfigSection search = root.subsection("search");
            this.searchModNameInTooltips = search.addBoolean("searchModNameInTooltips", false, "Should the mod name be included when searching in tooltips.");
            this.useExternalSearch = search.addBoolean("useExternalSearch", false, "Replaces AEs own search with the search of REI or JEI");
            this.clearExternalSearchOnOpen = search.addBoolean("clearExternalSearchOnOpen", true, "When using useExternalSearch, clears the search when the terminal opens");
            this.syncWithExternalSearch = search.addBoolean("syncWithExternalSearch", true, "When REI/JEI is installed, automatically set the AE or REI/JEI search text when either is changed while the terminal is open");
            this.rememberLastSearch = search.addBoolean("rememberLastSearch", true, "Remembers the last search term and restores it when the terminal opens");
            this.autoFocusSearch = search.addBoolean("autoFocusSearch", false, "Automatically focuses the search field when the terminal opens");
            ConfigSection tooltips = root.subsection("tooltips");
            this.tooltipShowCellUpgrades = tooltips.addBoolean("showCellUpgrades", true, "Show installed upgrades in the tooltips of storage cells, color applicators and matter cannons");
            this.tooltipShowCellContent = tooltips.addBoolean("showCellContent", true, "Show a preview of the content in the tooltips of storage cells, color applicators and matter cannons");
            this.tooltipMaxCellContentShown = tooltips.addInt("maxCellContentShown", 5, 1, 32, "The maximum number of content entries to show in the tooltip of storage cells, color applicators and matter cannons");
            this.enableGuideHotkey = tooltips.addBoolean("enableGuideHotkey", true, "Enables the 'hold key to show guide' functionality in tooltips");
        }
    }

    private static class CommonConfig {
        public final IntegerOption formationPlaneEntityLimit;
        public final IntegerOption craftingCalculationTimePerTick;
        public final BooleanOption craftingSimulatedExtraction;
        public final BooleanOption allowBlockEntityFacades;
        public final BooleanOption debugTools;
        public final BooleanOption matterCannonBlockDamage;
        public final BooleanOption tinyTntBlockDamage;
        public final EnumOption<ChannelMode> channels;
        public final BooleanOption spatialAnchorEnableRandomTicks;
        public final BooleanOption disassemblyCrafting;
        public final IntegerOption growthAcceleratorSpeed;
        public final DoubleOption spatialPowerExponent;
        public final DoubleOption spatialPowerMultiplier;
        public final BooleanOption blockUpdateLog;
        public final BooleanOption packetLog;
        public final BooleanOption craftingLog;
        public final BooleanOption debugLog;
        public final BooleanOption gridLog;
        public final BooleanOption chunkLoggerTrace;
        public final DoubleOption chargerChargeRate;
        public final IntegerOption wirelessTerminalBattery;
        public final IntegerOption entropyManipulatorBattery;
        public final IntegerOption matterCannonBattery;
        public final IntegerOption portableCellBattery;
        public final IntegerOption colorApplicatorBattery;
        public final IntegerOption chargedStaffBattery;
        public final BooleanOption spawnPressesInMeteorites;
        public final BooleanOption spawnFlawlessOnly;
        public final DoubleOption wirelessBaseCost;
        public final DoubleOption wirelessCostMultiplier;
        public final DoubleOption wirelessTerminalDrainMultiplier;
        public final DoubleOption wirelessBaseRange;
        public final DoubleOption wirelessBoosterRangeMultiplier;
        public final DoubleOption wirelessBoosterExp;
        public final DoubleOption wirelessHighWirelessCount;
        public final BooleanOption portableCellDisassembly;
        public final DoubleOption powerRatioForgeEnergy;
        public final DoubleOption powerUsageMultiplier;
        public final DoubleOption gridEnergyStoragePerNode;
        public final DoubleOption crystalResonanceGeneratorRate;
        public final DoubleOption p2pTunnelEnergyTax;
        public final DoubleOption p2pTunnelTransportTax;
        public final DoubleOption vibrationChamberBaseEnergyPerFuelTick;
        public final IntegerOption vibrationChamberMinEnergyPerTick;
        public final IntegerOption vibrationChamberMaxEnergyPerTick;
        public final IntegerOption condenserMatterBallsPower;
        public final IntegerOption condenserSingularityPower;
        public final Map<TickRates, IntegerOption> tickRateMin = new HashMap<TickRates, IntegerOption>();
        public final Map<TickRates, IntegerOption> tickRateMax = new HashMap<TickRates, IntegerOption>();

        public CommonConfig(ConfigSection root) {
            ConfigSection general = root.subsection("general");
            this.debugTools = general.addBoolean("unsupportedDeveloperTools", Platform.isDevelopmentEnvironment());
            this.matterCannonBlockDamage = general.addBoolean("matterCannonBlockDamage", true, "Enables the ability of the Matter Cannon to break blocks.");
            this.tinyTntBlockDamage = general.addBoolean("tinyTntBlockDamage", true, "Enables the ability of Tiny TNT to break blocks.");
            this.channels = general.addEnum("channels", ChannelMode.DEFAULT, "Changes the channel capacity that cables provide in AE2.");
            this.spatialAnchorEnableRandomTicks = general.addBoolean("spatialAnchorEnableRandomTicks", true, "Whether Spatial Anchors should force random chunk ticks and entity spawning.");
            ConfigSection automation = root.subsection("automation");
            this.formationPlaneEntityLimit = automation.addInt("formationPlaneEntityLimit", 128);
            ConfigSection facades = root.subsection("facades");
            this.allowBlockEntityFacades = facades.addBoolean("allowBlockEntities", false, "Unsupported: Allows whitelisting block entities as facades. Could work, have render issues, or corrupt your world. USE AT YOUR OWN RISK.");
            ConfigSection craftingCPU = root.subsection("craftingCPU");
            this.craftingCalculationTimePerTick = craftingCPU.addInt("craftingCalculationTimePerTick", 5);
            this.craftingSimulatedExtraction = craftingCPU.addBoolean("craftingSimulatedExtraction", false, "When true: simulate extraction of all the network's contents when starting a crafting job calculation. When false: use the cached available content list (same as terminals). Enabling might work a bit better, but it will significantly reduce performance.");
            ConfigSection crafting = root.subsection("crafting");
            this.disassemblyCrafting = crafting.addBoolean("disassemblyCrafting", true, "Enable shift-clicking with the crafting units in hand to disassemble them.");
            this.growthAcceleratorSpeed = crafting.addInt("growthAccelerator", 10, 1, 100, "Number of ticks between two crystal growth accelerator ticks");
            ConfigSection spatialio = root.subsection("spatialio");
            this.spatialPowerMultiplier = spatialio.addDouble("spatialPowerMultiplier", 1250.0);
            this.spatialPowerExponent = spatialio.addDouble("spatialPowerExponent", 1.35);
            ConfigSection logging = root.subsection("logging");
            this.blockUpdateLog = logging.addBoolean("blockUpdateLog", false);
            this.packetLog = logging.addBoolean("packetLog", false);
            this.craftingLog = logging.addBoolean("craftingLog", false);
            this.debugLog = logging.addBoolean("debugLog", false);
            this.gridLog = logging.addBoolean("gridLog", false);
            this.chunkLoggerTrace = logging.addBoolean("chunkLoggerTrace", false, "Enable stack trace logging for the chunk loading debug command");
            ConfigSection battery = root.subsection("battery");
            this.chargerChargeRate = battery.addDouble("chargerChargeRate", 1.0, 0.1, 10.0, "The chargers charging rate factor, which is applied to the charged items charge rate. 2 means it charges everything twice as fast. 0.5 half as fast.");
            this.wirelessTerminalBattery = battery.addInt("wirelessTerminal", 1600000);
            this.chargedStaffBattery = battery.addInt("chargedStaff", 8000);
            this.entropyManipulatorBattery = battery.addInt("entropyManipulator", 200000);
            this.portableCellBattery = battery.addInt("portableCell", 20000);
            this.colorApplicatorBattery = battery.addInt("colorApplicator", 20000);
            this.matterCannonBattery = battery.addInt("matterCannon", 200000);
            ConfigSection worldGen = root.subsection("worldGen");
            this.spawnPressesInMeteorites = worldGen.addBoolean("spawnPressesInMeteorites", true);
            this.spawnFlawlessOnly = worldGen.addBoolean("spawnFlawlessOnly", false);
            ConfigSection wireless = root.subsection("wireless");
            this.wirelessBaseCost = wireless.addDouble("wirelessBaseCost", 8.0);
            this.wirelessCostMultiplier = wireless.addDouble("wirelessCostMultiplier", 1.0);
            this.wirelessBaseRange = wireless.addDouble("wirelessBaseRange", 16.0);
            this.wirelessBoosterRangeMultiplier = wireless.addDouble("wirelessBoosterRangeMultiplier", 1.0);
            this.wirelessBoosterExp = wireless.addDouble("wirelessBoosterExp", 1.5);
            this.wirelessHighWirelessCount = wireless.addDouble("wirelessHighWirelessCount", 64.0);
            this.wirelessTerminalDrainMultiplier = wireless.addDouble("wirelessTerminalDrainMultiplier", 1.0);
            ConfigSection portableCells = root.subsection("PortableCells");
            this.portableCellDisassembly = portableCells.addBoolean("allowDisassembly", true, "Allow disassembly of portable cells into the recipe ingredients using shift+right-click");
            ConfigSection PowerRatios = root.subsection("PowerRatios");
            this.powerRatioForgeEnergy = PowerRatios.addDouble("ForgeEnergy", 0.5);
            this.powerUsageMultiplier = PowerRatios.addDouble("UsageMultiplier", 1.0, 0.01, Double.MAX_VALUE);
            this.gridEnergyStoragePerNode = PowerRatios.addDouble("GridEnergyStoragePerNode", 25.0, 1.0, 1000000.0, "How much energy can the internal grid buffer storage per node attached to the grid.");
            this.crystalResonanceGeneratorRate = PowerRatios.addDouble("CrystalResonanceGeneratorRate", 20.0, 0.0, 1000000.0, "How much energy a crystal resonance generator generates per tick.");
            this.p2pTunnelEnergyTax = PowerRatios.addDouble("p2pTunnelEnergyTax", 0.025, 0.0, 1.0, "The cost to transport energy through an energy P2P tunnel expressed as a factor of the transported energy.");
            this.p2pTunnelTransportTax = PowerRatios.addDouble("p2pTunnelTransportTax", 0.025, 0.0, 1.0, "The cost to transport items/fluids/etc. through P2P tunnels, expressed in AE energy per equivalent I/O bus operation for the transported object type (i.e. items=per 1 item, fluids=per 125mb).");
            ConfigSection Condenser = root.subsection("Condenser");
            this.condenserMatterBallsPower = Condenser.addInt("MatterBalls", 256);
            this.condenserSingularityPower = Condenser.addInt("Singularity", 256000);
            ConfigSection tickrates = root.subsection("tickRates", " Min / Max Tickrates for dynamic ticking, most of these components also use sleeping, to prevent constant ticking, adjust with care, non standard rates are not supported or tested.");
            for (TickRates tickRate : TickRates.values()) {
                this.tickRateMin.put(tickRate, tickrates.addInt(tickRate.name() + "Min", tickRate.getDefaultMin()));
                this.tickRateMax.put(tickRate, tickrates.addInt(tickRate.name() + "Max", tickRate.getDefaultMax()));
            }
            ConfigSection vibrationChamber = root.subsection("vibrationChamber", "Settings for the Vibration Chamber");
            this.vibrationChamberBaseEnergyPerFuelTick = vibrationChamber.addDouble("baseEnergyPerFuelTick", 5.0, 0.1, 1000.0, "AE energy produced per fuel burn tick (reminder: coal = 1600, block of coal = 16000, lava bucket = 20000 burn ticks)");
            this.vibrationChamberMinEnergyPerTick = vibrationChamber.addInt("minEnergyPerGameTick", 4, 0, 1000, "Minimum amount of AE/t the vibration chamber can slow down to when energy is being wasted.");
            this.vibrationChamberMaxEnergyPerTick = vibrationChamber.addInt("baseMaxEnergyPerGameTick", 40, 1, 1000, "Maximum amount of AE/t the vibration chamber can speed up to when generated energy is being fully consumed.");
        }
    }
}

