/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public final class WrenchHook {
    private static final ThreadLocal<Boolean> IS_DISASSEMBLING = new ThreadLocal();

    private WrenchHook() {
    }

    public static boolean isDisassembling() {
        return Boolean.TRUE.equals(IS_DISASSEMBLING.get());
    }

    public static void onPlayerUseBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        InteractionResult result = WrenchHook.onPlayerUseBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InteractionResult onPlayerUseBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos pos;
        BlockState state;
        IOrientationStrategy strategy;
        if (player.m_5833_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (InteractionUtil.isInAlternateUseMode(player) && InteractionUtil.canWrenchDisassemble(itemStack)) {
            BlockEntity be = level.m_7702_(hitResult.m_82425_());
            if (be instanceof AEBaseBlockEntity) {
                AEBaseBlockEntity baseBlockEntity = (AEBaseBlockEntity)be;
                IS_DISASSEMBLING.set(true);
                try {
                    SoundEvent soundType;
                    if (!Platform.hasPermissions(new DimensionalBlockPos(level, hitResult.m_82425_()), player)) {
                        InteractionResult interactionResult = InteractionResult.FAIL;
                        return interactionResult;
                    }
                    InteractionResult result = baseBlockEntity.disassembleWithWrench(player, level, hitResult, itemStack);
                    if (result.m_19077_()) {
                        soundType = SoundEvents.f_12016_;
                        level.m_5594_(player, hitResult.m_82425_(), soundType, SoundSource.BLOCKS, 0.7f, 1.0f);
                    }
                    soundType = result;
                    return soundType;
                }
                finally {
                    IS_DISASSEMBLING.remove();
                }
            }
        } else if (!InteractionUtil.isInAlternateUseMode(player) && InteractionUtil.canWrenchRotate(itemStack) && (strategy = IOrientationStrategy.get(state = level.m_8055_(pos = hitResult.m_82425_()))).allowsPlayerRotation()) {
            Direction clickedFace = hitResult.m_82434_();
            BlockOrientation orientation = BlockOrientation.get(strategy, state);
            BlockState newState = strategy.setOrientation(state, (orientation = orientation.rotateClockwiseAround(clickedFace)).getSide(RelativeSide.FRONT), orientation.getSpin());
            if (newState != state && newState.m_60710_((LevelReader)level, pos)) {
                if (!Platform.hasPermissions(new DimensionalBlockPos(level, hitResult.m_82425_()), player)) {
                    return InteractionResult.FAIL;
                }
                level.m_46597_(pos, newState);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }
}

