/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.api.orientation.BlockOrientation;
import appeng.blockentity.storage.ChestBlockEntity;
import appeng.client.render.BakedModelUnwrapper;
import appeng.client.render.DelegateBakedModel;
import appeng.client.render.model.DriveBakedModel;
import appeng.client.render.tesr.CellLedRenderer;
import appeng.core.definitions.AEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class ChestBlockEntityRenderer
implements BlockEntityRenderer<ChestBlockEntity> {
    private final ModelManager modelManager;
    private final ModelBlockRenderer blockRenderer;

    public ChestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft client = Minecraft.m_91087_();
        this.modelManager = client.m_91304_();
        this.blockRenderer = client.m_91289_().m_110937_();
    }

    public void render(ChestBlockEntity chest, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        Level level = chest.m_58904_();
        if (level == null) {
            return;
        }
        Item cellItem = chest.getCellItem(0);
        if (cellItem == null) {
            return;
        }
        DriveBakedModel driveModel = this.getDriveModel();
        if (driveModel == null) {
            return;
        }
        BakedModel cellModel = driveModel.getCellChassisModel(cellItem);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        BlockOrientation rotation = BlockOrientation.get(chest);
        poseStack.m_252781_(rotation.getQuaternion());
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        poseStack.m_85837_(0.3125, 0.25, 0.0);
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
        FaceRotatingModel rotatedModel = new FaceRotatingModel(cellModel, rotation);
        this.blockRenderer.tesselateBlock((BlockAndTintGetter)level, (BakedModel)rotatedModel, chest.m_58900_(), chest.m_58899_(), poseStack, buffer, false, RandomSource.m_216327_(), 0L, combinedOverlay, ModelData.EMPTY, null);
        VertexConsumer ledBuffer = buffers.m_6299_(CellLedRenderer.RENDER_LAYER);
        CellLedRenderer.renderLed(chest, 0, ledBuffer, poseStack, partialTicks);
        poseStack.m_85849_();
    }

    private DriveBakedModel getDriveModel() {
        BakedModel driveModel = this.modelManager.m_119430_().m_110893_(AEBlocks.DRIVE.block().m_49966_());
        return BakedModelUnwrapper.unwrap(driveModel, DriveBakedModel.class);
    }

    public static class FaceRotatingModel
    extends DelegateBakedModel {
        private final BlockOrientation r;

        protected FaceRotatingModel(BakedModel base, BlockOrientation r) {
            super(base);
            this.r = r;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
            if (side != null) {
                side = this.r.resultingRotate(side);
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData, renderType));
            for (int i = 0; i < quads.size(); ++i) {
                BakedQuad quad = (BakedQuad)quads.get(i);
                quads.set(i, new BakedQuad(quad.m_111303_(), quad.m_111305_(), this.r.rotate(quad.m_111306_()), quad.m_173410_(), quad.m_111307_()));
            }
            return quads;
        }
    }
}

