/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.datagen.providers.tags.ConventionTags;
import appeng.items.tools.NetworkToolItem;
import appeng.util.LookDirection;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public final class InteractionUtil {
    private InteractionUtil() {
    }

    public static boolean canWrenchDisassemble(ItemStack tool) {
        return tool.is(ConventionTags.WRENCH);
    }

    public static boolean canWrenchRotate(ItemStack tool) {
        if (tool.getItem() instanceof NetworkToolItem) {
            return false;
        }
        return tool.is(ConventionTags.WRENCH);
    }

    public static boolean isInAlternateUseMode(Player player) {
        return player.isShiftKeyDown();
    }

    public static float getEyeOffset(Player player) {
        assert (player.level().isClientSide) : "Valid only on client";
        return (float)(player.getY() + (double)player.getEyeHeight() - (double)1.62f);
    }

    public static LookDirection getPlayerRay(Player playerIn) {
        double reachDistance = playerIn.getAttribute((Attribute)ForgeMod.BLOCK_REACH.get()).getValue();
        return InteractionUtil.getPlayerRay(playerIn, reachDistance);
    }

    public static LookDirection getPlayerRay(Player playerIn, double reachDistance) {
        double x = playerIn.xo + (playerIn.getX() - playerIn.xo);
        double y = playerIn.yo + (playerIn.getY() - playerIn.yo) + (double)playerIn.getEyeHeight();
        double z = playerIn.zo + (playerIn.getZ() - playerIn.zo);
        float playerPitch = playerIn.xRotO + (playerIn.getXRot() - playerIn.xRotO);
        float playerYaw = playerIn.yRotO + (playerIn.getYRot() - playerIn.yRotO);
        float yawRayX = Mth.sin((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = Mth.cos((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -Mth.cos((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = Mth.sin((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        Vec3 from = new Vec3(x, y, z);
        Vec3 to = from.add((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return new LookDirection(from, to);
    }

    public static HitResult rayTrace(Player p, boolean hitBlocks, boolean hitEntities) {
        Level level = p.getCommandSenderWorld();
        float f = 1.0f;
        float f1 = p.xRotO + (p.getXRot() - p.xRotO) * 1.0f;
        float f2 = p.yRotO + (p.getYRot() - p.yRotO) * 1.0f;
        double d0 = p.xo + (p.getX() - p.xo) * 1.0;
        double d1 = p.yo + (p.getY() - p.yo) * 1.0 + 1.62 - p.getMyRidingOffset();
        double d2 = p.zo + (p.getZ() - p.zo) * 1.0;
        Vec3 vec3 = new Vec3(d0, d1, d2);
        float f3 = Mth.cos((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = Mth.sin((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -Mth.cos((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = Mth.sin((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 32.0;
        Vec3 vec31 = vec3.add((double)f7 * 32.0, (double)f6 * 32.0, (double)f8 * 32.0);
        AABB bb = new AABB(Math.min(vec3.x, vec31.x), Math.min(vec3.y, vec31.y), Math.min(vec3.z, vec31.z), Math.max(vec3.x, vec31.x), Math.max(vec3.y, vec31.y), Math.max(vec3.z, vec31.z)).inflate(16.0, 16.0, 16.0);
        Entity entity = null;
        double closest = 9999999.0;
        if (hitEntities) {
            List list = level.getEntities((Entity)p, bb);
            for (Entity entity1 : list) {
                double nd;
                if (!entity1.isAlive() || entity1 == p || entity1 instanceof ItemEntity || entity1.hasIndirectPassenger((Entity)p)) continue;
                f1 = 0.3f;
                AABB boundingBox = entity1.getBoundingBox().inflate((double)f1, (double)f1, (double)f1);
                Vec3 rtResult = boundingBox.clip(vec3, vec31).orElse(null);
                if (rtResult == null || !((nd = vec3.distanceToSqr(rtResult)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
        }
        EntityHitResult pos = null;
        Vec3 vec = null;
        if (hitBlocks) {
            vec = new Vec3(d0, d1, d2);
            pos = level.clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)p));
        }
        if (entity != null && pos != null && pos.getLocation().distanceToSqr(vec) > closest) {
            pos = new EntityHitResult(entity);
        } else if (entity != null && pos == null) {
            pos = new EntityHitResult(entity);
        }
        return pos;
    }
}

