/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public final class EnchantmentUtil {
    private EnchantmentUtil() {
    }

    @Nullable
    public static Map<Enchantment, Integer> getEnchantments(CompoundTag data) {
        ListTag list;
        Map enchants;
        if (data.contains("Enchantments", 9) && !(enchants = EnchantmentHelper.deserializeEnchantments((ListTag)(list = data.getList("Enchantments", 10)))).isEmpty()) {
            return enchants;
        }
        return null;
    }

    public static void setEnchantments(CompoundTag tag, Map<Enchantment, Integer> enchantments) {
        ListTag enchantList = new ListTag();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int level = entry.getValue();
            enchantList.add((Object)EnchantmentHelper.storeEnchantment((ResourceLocation)EnchantmentHelper.getEnchantmentId((Enchantment)enchantment), (int)level));
        }
        tag.put("Enchantments", (Tag)enchantList);
    }
}

