/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.core.AppEngClient;
import appeng.core.definitions.AEBlocks;
import appeng.items.tools.powered.MatterCannonItem;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import appeng.siteexport.FabricClientCommandSource;
import guideme.Guide;
import guideme.internal.siteexport.SiteExporter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.Nullable;

public class AESiteExporter
extends SiteExporter {
    public AESiteExporter(Minecraft client, Path outputFolder, Guide guide) {
        super(client, outputFolder, guide);
        this.referenceItem((ItemLike)Items.FURNACE);
        this.referenceItem(AEBlocks.INSCRIBER);
        this.referenceFluid((Fluid)Fluids.WATER);
        this.referenceFluid((Fluid)Fluids.LAVA);
        this.referenceItem((ItemLike)Items.TNT);
        this.referenceItem((ItemLike)Blocks.SMITHING_TABLE);
    }

    public static void initialize() {
        if (Boolean.getBoolean("appeng.runGuideExportAndExit")) {
            Path outputFolder = Paths.get(System.getProperty("appeng.guideExportFolder"), new String[0]);
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                if (evt.phase == TickEvent.Phase.END) {
                    Minecraft client = Minecraft.getInstance();
                    if (client.getOverlay() instanceof LoadingOverlay) {
                        return;
                    }
                    Guide guide = AppEngClient.instance().getGuide();
                    try {
                        new AESiteExporter(Minecraft.getInstance(), outputFolder, guide).exportOnNextTickAndExit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            });
        }
    }

    public static void export(FabricClientCommandSource source) {
        Guide guide = AppEngClient.instance().getGuide();
        try {
            Path outputFolder = Paths.get("guide-export", new String[0]).toAbsolutePath();
            AESiteExporter.export(Minecraft.getInstance(), outputFolder, guide);
            source.sendFeedback((Component)Component.literal((String)"Guide data exported to ").append((Component)Component.literal((String)("[" + outputFolder.getFileName().toString() + "]")).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, outputFolder.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to open export folder"))).applyFormats(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}))));
        }
        catch (Exception e) {
            e.printStackTrace();
            source.sendError((Component)Component.literal((String)e.toString()));
        }
    }

    private static void export(Minecraft client, Path outputFolder, Guide guide) throws Exception {
        new AESiteExporter(client, outputFolder, guide).exportOnNextTickAndExit();
    }

    @Nullable
    protected Map<String, Object> getCustomRecipeFields(ResourceLocation id, Recipe<?> recipe) {
        if (recipe instanceof InscriberRecipe) {
            InscriberRecipe inscriberRecipe = (InscriberRecipe)recipe;
            return this.addRecipe(inscriberRecipe);
        }
        if (recipe instanceof TransformRecipe) {
            TransformRecipe transformRecipe = (TransformRecipe)recipe;
            return this.addRecipe(transformRecipe);
        }
        if (recipe instanceof EntropyRecipe) {
            EntropyRecipe entropyRecipe = (EntropyRecipe)recipe;
            return this.addRecipe(entropyRecipe);
        }
        if (recipe instanceof MatterCannonAmmo) {
            MatterCannonAmmo ammoRecipe = (MatterCannonAmmo)recipe;
            return this.addRecipe(ammoRecipe);
        }
        if (recipe instanceof ChargerRecipe) {
            ChargerRecipe chargerRecipe = (ChargerRecipe)recipe;
            return this.addRecipe(chargerRecipe);
        }
        return null;
    }

    private Map<String, Object> addRecipe(InscriberRecipe recipe) {
        ItemStack resultItem = recipe.getResultItem();
        return Map.of("top", recipe.getTopOptional(), "middle", recipe.getMiddleInput(), "bottom", recipe.getBottomOptional(), "resultItem", resultItem.getItem(), "resultCount", resultItem.getCount(), "consumesTopAndBottom", recipe.getProcessType() == InscriberProcessType.PRESS);
    }

    private Map<String, Object> addRecipe(TransformRecipe recipe) {
        HashMap<String, Object> circumstanceJson = new HashMap<String, Object>();
        TransformCircumstance circumstance = recipe.circumstance;
        if (circumstance.isExplosion()) {
            circumstanceJson.put("type", "explosion");
        } else if (circumstance.isFluid()) {
            circumstanceJson.put("type", "fluid");
            if (recipe.circumstance.isFluidTag((TagKey<Fluid>)FluidTags.WATER)) {
                circumstanceJson.put("fluids", List.of(Fluids.WATER));
            } else {
                circumstanceJson.put("fluids", circumstance.getFluidsForRendering());
            }
        } else {
            throw new IllegalStateException("Unknown circumstance: " + circumstance.toJson());
        }
        return Map.of("resultItem", recipe.getResultItem(null), "ingredients", recipe.getIngredients(), "circumstance", circumstanceJson);
    }

    private Map<String, Object> addRecipe(EntropyRecipe recipe) {
        return Map.of("mode", recipe.getMode().name().toLowerCase(Locale.ROOT));
    }

    private Map<String, Object> addRecipe(MatterCannonAmmo recipe) {
        return Map.of("ammo", recipe.getAmmo(), "damage", MatterCannonItem.getDamageFromPenetration(recipe.getWeight()));
    }

    private Map<String, Object> addRecipe(ChargerRecipe recipe) {
        return Map.of("resultItem", recipe.getResultItem(), "ingredient", recipe.getIngredient());
    }
}

