/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.services;

import appeng.blockentity.spatial.SpatialAnchorBlockEntity;
import appeng.server.services.ChunkLoadState;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;

public class ChunkLoadingService
implements ForgeChunkManager.LoadingValidationCallback {
    private static final ChunkLoadingService INSTANCE = new ChunkLoadingService();
    private boolean running = true;

    public static void register() {
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"ae2", (ForgeChunkManager.LoadingValidationCallback)INSTANCE);
    }

    public void onServerAboutToStart(ServerAboutToStartEvent evt) {
        this.running = true;
    }

    public void onServerStopping(ServerStoppingEvent event) {
        this.running = false;
    }

    public static ChunkLoadingService getInstance() {
        return INSTANCE;
    }

    public void validateTickets(ServerLevel level, ForgeChunkManager.TicketHelper ticketHelper) {
        ticketHelper.getBlockTickets().forEach((blockPos, chunks) -> {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof SpatialAnchorBlockEntity) {
                SpatialAnchorBlockEntity anchor = (SpatialAnchorBlockEntity)blockEntity;
                for (Long chunk : (LongSet)chunks.getSecond()) {
                    anchor.registerChunk(new ChunkPos(chunk.longValue()));
                }
            } else {
                ticketHelper.removeAllTickets(blockPos);
            }
        });
    }

    public boolean forceChunk(ServerLevel level, BlockPos owner, ChunkPos position, boolean ticking) {
        if (this.running) {
            return ForgeChunkManager.forceChunk((ServerLevel)level, (String)"ae2", (BlockPos)owner, (int)position.x, (int)position.z, (boolean)true, (boolean)true);
        }
        return false;
    }

    public boolean releaseChunk(ServerLevel level, BlockPos owner, ChunkPos position, boolean ticking) {
        if (this.running) {
            return ForgeChunkManager.forceChunk((ServerLevel)level, (String)"ae2", (BlockPos)owner, (int)position.x, (int)position.z, (boolean)false, (boolean)true);
        }
        return false;
    }

    public boolean isChunkForced(ServerLevel level, int chunkX, int chunkZ) {
        return ChunkLoadState.get(level).isForceLoaded(chunkX, chunkZ);
    }
}

