/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.transform;

import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class TransformRecipeSerializer
implements RecipeSerializer<TransformRecipe> {
    public static final TransformRecipeSerializer INSTANCE = new TransformRecipeSerializer();

    private TransformRecipeSerializer() {
    }

    public TransformRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        NonNullList ingredients = NonNullList.create();
        GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients").forEach(ingredient -> ingredients.add((Object)Ingredient.fromJson((JsonElement)ingredient)));
        ItemStack result = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
        TransformCircumstance circumstance = json.has("circumstance") ? TransformCircumstance.fromJson(GsonHelper.getAsJsonObject((JsonObject)json, (String)"circumstance")) : TransformCircumstance.fluid((TagKey<Fluid>)FluidTags.WATER);
        return new TransformRecipe(recipeId, (NonNullList<Ingredient>)ingredients, result, circumstance);
    }

    @Nullable
    public TransformRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ItemStack output = buffer.readItem();
        int size = buffer.readByte();
        NonNullList ingredients = NonNullList.create();
        for (int i = 0; i < size; ++i) {
            ingredients.add((Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
        }
        TransformCircumstance circumstance = TransformCircumstance.fromNetwork(buffer);
        return new TransformRecipe(recipeId, (NonNullList<Ingredient>)ingredients, output, circumstance);
    }

    public void toNetwork(FriendlyByteBuf buffer, TransformRecipe recipe) {
        buffer.writeItem(recipe.output);
        buffer.writeByte(recipe.ingredients.size());
        recipe.ingredients.forEach(ingredient -> ingredient.toNetwork(buffer));
        recipe.circumstance.toNetwork(buffer);
    }
}

