/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.transform;

import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipeSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformRecipeBuilder {
    public static void transform(Consumer<FinishedRecipe> consumer, ResourceLocation id, ItemLike output, int count, TransformCircumstance circumstance, ItemLike ... inputs) {
        consumer.accept(new Result(id, Stream.of(inputs).map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0})).toList(), output, count, circumstance));
    }

    public static void transform(Consumer<FinishedRecipe> consumer, ResourceLocation id, ItemLike output, int count, TransformCircumstance circumstance, Ingredient ... inputs) {
        consumer.accept(new Result(id, List.of(inputs), output, count, circumstance));
    }

    record Result(ResourceLocation id, List<Ingredient> ingredients, ItemLike output, int count, TransformCircumstance circumstance) implements FinishedRecipe
    {
        public void serializeRecipeData(@NotNull JsonObject json) {
            JsonObject stackObj = new JsonObject();
            stackObj.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)this.output.asItem()).toString());
            if (this.count > 1) {
                stackObj.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)stackObj);
            JsonArray inputs = new JsonArray();
            this.ingredients.forEach(ingredient -> inputs.add(ingredient.toJson()));
            json.add("ingredients", (JsonElement)inputs);
            json.add("circumstance", (JsonElement)this.circumstance.toJson());
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return TransformRecipeSerializer.INSTANCE;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }
}

