/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.transform;

import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class TransformLogic {
    static Map<Fluid, Set<Item>> fluidCache = new IdentityHashMap<Fluid, Set<Item>>();
    static Set<Item> explosionCache = null;
    static Set<Item> anyFluidCache = null;

    public static boolean canTransformInFluid(ItemEntity entity, FluidState fluid) {
        return TransformLogic.getTransformableItems(entity.level(), fluid.getType()).contains(entity.getItem().getItem());
    }

    public static boolean canTransformInAnyFluid(ItemEntity entity) {
        return TransformLogic.getTransformableItemsAnyFluid(entity.level()).contains(entity.getItem().getItem());
    }

    public static boolean canTransformInExplosion(ItemEntity entity) {
        return TransformLogic.getTransformableItemsExplosion(entity.level()).contains(entity.getItem().getItem());
    }

    public static boolean tryTransform(ItemEntity entity, Predicate<TransformCircumstance> circumstancePredicate) {
        Level level = entity.level();
        AABB region = new AABB(entity.getX() - 1.0, entity.getY() - 1.0, entity.getZ() - 1.0, entity.getX() + 1.0, entity.getY() + 1.0, entity.getZ() + 1.0);
        List<ItemEntity> itemEntities = level.getEntities(null, region).stream().filter(e -> e instanceof ItemEntity && !e.isRemoved()).map(e -> (ItemEntity)e).toList();
        for (TransformRecipe recipe : level.getRecipeManager().byType(TransformRecipe.TYPE).values()) {
            if (!circumstancePredicate.test(recipe.circumstance) || recipe.ingredients.size() == 0) continue;
            ArrayList missingIngredients = Lists.newArrayList(recipe.ingredients);
            ReferenceOpenHashSet selectedEntities = new ReferenceOpenHashSet(missingIngredients.size());
            if (recipe.circumstance.isExplosion() ? missingIngredients.stream().noneMatch(i -> i.test(entity.getItem())) : !((Ingredient)missingIngredients.get(0)).test(entity.getItem())) continue;
            block1: for (ItemEntity itemEntity : itemEntities) {
                ItemStack other = itemEntity.getItem();
                if (other.isEmpty()) continue;
                Iterator it = missingIngredients.iterator();
                while (it.hasNext()) {
                    Ingredient ing = (Ingredient)it.next();
                    if (!ing.test(other)) continue;
                    selectedEntities.add(itemEntity);
                    it.remove();
                    continue block1;
                }
            }
            if (!missingIngredients.isEmpty()) continue;
            SimpleContainer recipeContainer = new SimpleContainer(selectedEntities.size());
            int i2 = 0;
            for (ItemEntity e2 : selectedEntities) {
                recipeContainer.setItem(i2++, e2.getItem().split(1));
                if (e2.getItem().getCount() > 0) continue;
                e2.discard();
            }
            RandomSource random = level.getRandom();
            double x = Math.floor(entity.getX()) + 0.25 + random.nextDouble() * 0.5;
            double y = Math.floor(entity.getY()) + 0.25 + random.nextDouble() * 0.5;
            double z = Math.floor(entity.getZ()) + 0.25 + random.nextDouble() * 0.5;
            double xSpeed = random.nextDouble() * 0.25 - 0.125;
            double ySpeed = random.nextDouble() * 0.25 - 0.125;
            double zSpeed = random.nextDouble() * 0.25 - 0.125;
            ItemEntity newEntity = new ItemEntity(level, x, y, z, recipe.assemble((Container)recipeContainer, level.registryAccess()));
            newEntity.setDeltaMovement(xSpeed, ySpeed, zSpeed);
            level.addFreshEntity((Entity)newEntity);
            return true;
        }
        return false;
    }

    private static void clearCache() {
        fluidCache.clear();
        explosionCache = null;
        anyFluidCache = null;
    }

    private static Set<Item> getTransformableItems(Level level, Fluid fluid) {
        return fluidCache.computeIfAbsent(fluid, f -> {
            Set ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.getRecipeManager().getAllRecipesFor(TransformRecipe.TYPE)) {
                Iterator iterator;
                if (!recipe.circumstance.isFluid(fluid) || !(iterator = recipe.ingredients.iterator()).hasNext()) continue;
                Ingredient ingredient = (Ingredient)iterator.next();
                for (ItemStack stack : ingredient.getItems()) {
                    ret.add(stack.getItem());
                }
            }
            return ret;
        });
    }

    private static Set<Item> getTransformableItemsAnyFluid(Level level) {
        Set<Object> ret = anyFluidCache;
        if (ret == null) {
            ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.getRecipeManager().getAllRecipesFor(TransformRecipe.TYPE)) {
                Iterator iterator;
                if (!recipe.circumstance.isFluid() || !(iterator = recipe.ingredients.iterator()).hasNext()) continue;
                Ingredient ingredient = (Ingredient)iterator.next();
                for (ItemStack stack : ingredient.getItems()) {
                    ret.add(stack.getItem());
                }
            }
            anyFluidCache = ret;
        }
        return ret;
    }

    private static Set<Item> getTransformableItemsExplosion(Level level) {
        Set<Object> ret = explosionCache;
        if (ret == null) {
            ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.getRecipeManager().getAllRecipesFor(TransformRecipe.TYPE)) {
                if (!recipe.circumstance.isExplosion()) continue;
                for (Ingredient ingredient : recipe.ingredients) {
                    for (ItemStack stack : ingredient.getItems()) {
                        ret.add(stack.getItem());
                    }
                }
            }
            explosionCache = ret;
        }
        return ret;
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent e) {
        TransformLogic.clearCache();
    }

    @SubscribeEvent
    public static void onReloadServerResources(AddReloadListenerEvent e) {
        TransformLogic.clearCache();
    }

    @SubscribeEvent
    public static void onClientRecipesUpdated(RecipesUpdatedEvent e) {
        TransformLogic.clearCache();
    }

    private TransformLogic() {
    }
}

