/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.mattercannon;

import appeng.recipes.mattercannon.MatterCannonAmmo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class MatterCannonAmmoSerializer
implements RecipeSerializer<MatterCannonAmmo> {
    public static final MatterCannonAmmoSerializer INSTANCE = new MatterCannonAmmoSerializer();

    private MatterCannonAmmoSerializer() {
    }

    public MatterCannonAmmo fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient ammo = Ingredient.fromJson((JsonElement)json.get("ammo"));
        float weight = json.get("weight").getAsFloat();
        return new MatterCannonAmmo(recipeId, ammo, weight);
    }

    @Nullable
    public MatterCannonAmmo fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient ammo = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        float weight = buffer.readFloat();
        return new MatterCannonAmmo(recipeId, ammo, weight);
    }

    public void toNetwork(FriendlyByteBuf buffer, MatterCannonAmmo recipe) {
        recipe.getAmmo().toNetwork(buffer);
        buffer.writeFloat(recipe.getWeight());
    }
}

