/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;

public class InscriberRecipeSerializer
implements RecipeSerializer<InscriberRecipe> {
    public static final InscriberRecipeSerializer INSTANCE = new InscriberRecipeSerializer();

    private InscriberRecipeSerializer() {
    }

    private static InscriberProcessType getMode(JsonObject json) {
        String mode;
        return switch (mode = GsonHelper.getAsString((JsonObject)json, (String)"mode", (String)"inscribe")) {
            case "inscribe" -> InscriberProcessType.INSCRIBE;
            case "press" -> InscriberProcessType.PRESS;
            default -> throw new IllegalStateException("Unknown mode for inscriber recipe: " + mode);
        };
    }

    public InscriberRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        InscriberProcessType mode = InscriberRecipeSerializer.getMode(json);
        ItemStack result = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
        JsonObject ingredients = GsonHelper.getAsJsonObject((JsonObject)json, (String)"ingredients");
        Ingredient middle = Ingredient.fromJson((JsonElement)ingredients.get("middle"));
        Ingredient top = Ingredient.EMPTY;
        if (ingredients.has("top")) {
            top = Ingredient.fromJson((JsonElement)ingredients.get("top"));
        }
        Ingredient bottom = Ingredient.EMPTY;
        if (ingredients.has("bottom")) {
            bottom = Ingredient.fromJson((JsonElement)ingredients.get("bottom"));
        }
        return new InscriberRecipe(recipeId, middle, result, top, bottom, mode);
    }

    @Nullable
    public InscriberRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient middle = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        ItemStack result = buffer.readItem();
        Ingredient top = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        Ingredient bottom = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        InscriberProcessType mode = (InscriberProcessType)buffer.readEnum(InscriberProcessType.class);
        return new InscriberRecipe(recipeId, middle, result, top, bottom, mode);
    }

    public void toNetwork(FriendlyByteBuf buffer, InscriberRecipe recipe) {
        recipe.getMiddleInput().toNetwork(buffer);
        buffer.writeItem(recipe.getResultItem());
        recipe.getTopOptional().toNetwork(buffer);
        recipe.getBottomOptional().toNetwork(buffer);
        buffer.writeEnum((Enum)recipe.getProcessType());
    }
}

