/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.recipes.handlers.ChargerRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class ChargerRecipeSerializer
implements RecipeSerializer<ChargerRecipe> {
    public static final ChargerRecipeSerializer INSTANCE = new ChargerRecipeSerializer();

    public ChargerRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
        Ingredient ingredient = Ingredient.fromJson((JsonElement)serializedRecipe.get("ingredient"));
        Item result = ShapedRecipe.itemFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)serializedRecipe, (String)"result"));
        return new ChargerRecipe(recipeId, ingredient, result);
    }

    public ChargerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        ItemStack result = buffer.readItem();
        return new ChargerRecipe(recipeId, ingredient, result.getItem());
    }

    public void toNetwork(FriendlyByteBuf buffer, ChargerRecipe recipe) {
        recipe.ingredient.toNetwork(buffer);
        buffer.writeItem(new ItemStack((ItemLike)recipe.result));
    }
}

