/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.recipes.handlers.ChargerRecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ChargerRecipeBuilder {
    public static void charge(Consumer<FinishedRecipe> consumer, ResourceLocation id, ItemLike input, ItemLike output) {
        consumer.accept(new Result(id, Ingredient.of((ItemLike[])new ItemLike[]{input}), output));
    }

    public static void charge(Consumer<FinishedRecipe> consumer, ResourceLocation id, TagKey<Item> input, ItemLike output) {
        consumer.accept(new Result(id, Ingredient.of(input), output));
    }

    public static void charge(Consumer<FinishedRecipe> consumer, ResourceLocation id, Ingredient input, ItemLike output) {
        consumer.accept(new Result(id, input, output));
    }

    record Result(ResourceLocation id, Ingredient input, ItemLike output) implements FinishedRecipe
    {
        public void serializeRecipeData(JsonObject json) {
            json.add("ingredient", this.input.toJson());
            JsonObject stackObj = new JsonObject();
            stackObj.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)this.output.asItem()).toString());
            json.add("result", (JsonElement)stackObj);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return ChargerRecipeSerializer.INSTANCE;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }
}

