/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.FacadeItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public final class FacadeRecipe
extends CustomRecipe {
    public static SimpleCraftingRecipeSerializer<FacadeRecipe> SERIALIZER = null;
    private final ItemDefinition<?> anchor = AEParts.CABLE_ANCHOR;
    private final FacadeItem facade;

    public FacadeRecipe(ResourceLocation id, CraftingBookCategory category, FacadeItem facade) {
        super(id, category);
        this.facade = facade;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        return !this.getOutput((Container)inv, false).isEmpty();
    }

    private ItemStack getOutput(Container inv, boolean createFacade) {
        if (inv.getItem(0).isEmpty() && inv.getItem(2).isEmpty() && inv.getItem(6).isEmpty() && inv.getItem(8).isEmpty() && this.anchor.isSameAs(inv.getItem(1)) && this.anchor.isSameAs(inv.getItem(3)) && this.anchor.isSameAs(inv.getItem(5)) && this.anchor.isSameAs(inv.getItem(7))) {
            ItemStack facades = this.facade.createFacadeForItem(inv.getItem(4), !createFacade);
            if (!facades.isEmpty() && createFacade) {
                facades.setCount(4);
            }
            return facades;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        return this.getOutput((Container)inv, true);
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public RecipeSerializer<FacadeRecipe> getSerializer() {
        return FacadeRecipe.getSerializer(this.facade);
    }

    public static RecipeSerializer<FacadeRecipe> getSerializer(FacadeItem facade) {
        if (SERIALIZER == null) {
            SERIALIZER = new SimpleCraftingRecipeSerializer((id, category) -> new FacadeRecipe(id, category, facade));
        }
        return SERIALIZER;
    }
}

