/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class StateApplier<T extends Comparable<T>> {
    private final Property<T> property;
    private final T value;

    private StateApplier(Property<T> property, String valueName) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.value = PropertyUtils.getRequiredPropertyValue(property, valueName);
    }

    <SH extends StateHolder<O, SH>, O> SH apply(SH state) {
        return (SH)((StateHolder)state.setValue(this.property, this.value));
    }

    void writeToPacket(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.property.getName());
        buffer.writeUtf(this.property.getName(this.value));
    }

    static StateApplier<?> create(StateDefinition<?, ?> stateDefinition, String propertyName, String value) {
        Property<?> property = PropertyUtils.getRequiredProperty(stateDefinition, propertyName);
        return new StateApplier(property, value);
    }

    @OnlyIn(value=Dist.CLIENT)
    static StateApplier<?> readFromPacket(StateDefinition<?, ?> stateDefinition, FriendlyByteBuf buffer) {
        String propertyName = buffer.readUtf();
        String value = buffer.readUtf();
        return StateApplier.create(stateDefinition, propertyName, value);
    }

    public Property<T> getProperty() {
        return this.property;
    }

    public String getValueName() {
        return this.property.getName(this.value);
    }
}

