/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class RangeValueMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final Property<T> property;
    private final T minValue;
    private final T maxValue;

    private RangeValueMatcher(Property<T> property, String minValueName, String maxValueName) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.minValue = PropertyUtils.getRequiredPropertyValue(property, minValueName);
        this.maxValue = PropertyUtils.getRequiredPropertyValue(property, maxValueName);
    }

    @Override
    public boolean matches(StateHolder<?, ?> state) {
        Comparable value = state.getValue(this.property);
        return value.compareTo(this.minValue) >= 0 && value.compareTo(this.maxValue) <= 0;
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)StateMatcher.MatcherType.RANGE);
        buffer.writeUtf(this.property.getName());
        buffer.writeUtf(this.property.getName(this.minValue));
        buffer.writeUtf(this.property.getName(this.maxValue));
    }

    @Override
    public Property<?> getProperty() {
        return this.property;
    }

    public String getMinValueName() {
        return this.property.getName(this.minValue);
    }

    public String getMaxValueName() {
        return this.property.getName(this.maxValue);
    }

    public static StateMatcher create(StateDefinition<?, ?> stateDefinition, String propertyName, String minValueName, String maxValueName) {
        Property<?> property = PropertyUtils.getRequiredProperty(stateDefinition, propertyName);
        return new RangeValueMatcher(property, minValueName, maxValueName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static StateMatcher readFromPacket(StateDefinition<?, ?> stateDefinition, FriendlyByteBuf buffer) {
        String propertyName = buffer.readUtf();
        String minName = buffer.readUtf();
        String maxName = buffer.readUtf();
        return RangeValueMatcher.create(stateDefinition, propertyName, minName, maxName);
    }
}

