/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import java.util.Objects;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

final class PropertyUtils {
    private PropertyUtils() {
    }

    static Property<?> getRequiredProperty(StateDefinition<?, ?> stateDefinition, String name) {
        Objects.requireNonNull(stateDefinition, "stateDefinition must not be null");
        Property property = stateDefinition.getProperty(name);
        if (property == null) {
            throw new IllegalArgumentException("Unknown property: " + name + " on " + stateDefinition.getOwner());
        }
        return property;
    }

    static <T extends Comparable<T>> T getRequiredPropertyValue(Property<T> property, String name) {
        Objects.requireNonNull(property, "property must be not null");
        return (T)((Comparable)property.getValue(name).orElseThrow(() -> new IllegalArgumentException("Invalid value '" + name + "' for property " + property.getName())));
    }
}

