/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class MultipleValuesMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final Property<T> property;
    private final Set<T> propertyValues;

    public MultipleValuesMatcher(Property<T> property, List<String> propertyValues) {
        this.property = Objects.requireNonNull(property, "property must be not null");
        this.propertyValues = propertyValues.stream().map(name -> PropertyUtils.getRequiredPropertyValue(property, name)).collect(Collectors.toSet());
    }

    @Override
    public boolean matches(StateHolder<?, ?> state) {
        return this.propertyValues.contains(state.getValue(this.property));
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)StateMatcher.MatcherType.MULTIPLE);
        buffer.writeUtf(this.property.getName());
        buffer.writeInt(this.propertyValues.size());
        for (Comparable value : this.propertyValues) {
            buffer.writeUtf(this.property.getName(value));
        }
    }

    @Override
    public Property<?> getProperty() {
        return this.property;
    }

    public Set<String> getValueNames() {
        return this.propertyValues.stream().map(arg_0 -> this.property.getName(arg_0)).collect(Collectors.toSet());
    }

    public static MultipleValuesMatcher<?> create(StateDefinition<?, ?> stateDefinition, String propertyName, List<String> values) {
        Property<?> property = PropertyUtils.getRequiredProperty(stateDefinition, propertyName);
        return new MultipleValuesMatcher(property, values);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MultipleValuesMatcher<?> readFromPacket(StateDefinition<?, ?> stateDefinition, FriendlyByteBuf buffer) {
        String propertyName = buffer.readUtf();
        int size = buffer.readInt();
        ArrayList<String> values = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            values.add(buffer.readUtf());
        }
        return MultipleValuesMatcher.create(stateDefinition, propertyName, values);
    }
}

