/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.EntropyRecipeBuilder;
import appeng.recipes.entropy.MultipleValuesMatcher;
import appeng.recipes.entropy.RangeValueMatcher;
import appeng.recipes.entropy.SingleValueMatcher;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class EntropyRecipeSerializer
implements RecipeSerializer<EntropyRecipe> {
    public static final EntropyRecipeSerializer INSTANCE = new EntropyRecipeSerializer();

    private EntropyRecipeSerializer() {
    }

    public EntropyRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject outputFluidObject;
        String outputFluidId;
        JsonObject outputJson;
        JsonObject outputBlockObject;
        String outputBlockId;
        JsonObject inputFluidObject;
        String inputFluidId;
        EntropyRecipeBuilder builder = new EntropyRecipeBuilder();
        builder.setId(recipeId);
        builder.setMode(EntropyMode.valueOf(GsonHelper.getAsString((JsonObject)json, (String)"mode").toUpperCase(Locale.ROOT)));
        JsonObject inputJson = GsonHelper.getAsJsonObject((JsonObject)json, (String)"input");
        JsonObject inputBlockObject = GsonHelper.getAsJsonObject((JsonObject)inputJson, (String)"block", (JsonObject)new JsonObject());
        String inputBlockId = GsonHelper.getAsString((JsonObject)inputBlockObject, (String)"id", null);
        if (inputBlockId != null) {
            Block block = (Block)EntropyRecipeSerializer.getRequiredEntry(BuiltInRegistries.BLOCK, inputBlockId);
            builder.setInputBlock(block);
            EntropyRecipeSerializer.parseStateMatchers(block.getStateDefinition(), inputBlockObject, builder::addBlockStateMatcher);
        }
        if ((inputFluidId = GsonHelper.getAsString((JsonObject)(inputFluidObject = GsonHelper.getAsJsonObject((JsonObject)inputJson, (String)"fluid", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Fluid fluid = (Fluid)EntropyRecipeSerializer.getRequiredEntry(BuiltInRegistries.FLUID, inputFluidId);
            builder.setInputFluid(fluid);
            EntropyRecipeSerializer.parseStateMatchers(fluid.getStateDefinition(), inputFluidObject, builder::addFluidStateMatcher);
        }
        if ((outputBlockId = GsonHelper.getAsString((JsonObject)(outputBlockObject = GsonHelper.getAsJsonObject((JsonObject)(outputJson = GsonHelper.getAsJsonObject((JsonObject)json, (String)"output")), (String)"block", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Block block = (Block)EntropyRecipeSerializer.getRequiredEntry(BuiltInRegistries.BLOCK, outputBlockId);
            builder.setOutputBlock(block);
            boolean outputBlockKeep = GsonHelper.getAsBoolean((JsonObject)outputBlockObject, (String)"keep", (boolean)false);
            builder.setOutputBlockKeep(outputBlockKeep);
            EntropyRecipeSerializer.parseStateAppliers(block.getStateDefinition(), outputBlockObject, builder::addBlockStateAppliers);
        }
        if ((outputFluidId = GsonHelper.getAsString((JsonObject)(outputFluidObject = GsonHelper.getAsJsonObject((JsonObject)outputJson, (String)"fluid", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Fluid fluid = (Fluid)EntropyRecipeSerializer.getRequiredEntry(BuiltInRegistries.FLUID, outputFluidId);
            builder.setOutputFluid(fluid);
            boolean outputFluidKeep = GsonHelper.getAsBoolean((JsonObject)outputFluidObject, (String)"keep", (boolean)false);
            builder.setOutputFluidKeep(outputFluidKeep);
            EntropyRecipeSerializer.parseStateAppliers(fluid.getStateDefinition(), outputFluidObject, builder::addFluidStateAppliers);
        }
        if (outputJson.has("drops")) {
            JsonArray dropList = GsonHelper.getAsJsonArray((JsonObject)outputJson, (String)"drops");
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(dropList.size());
            for (JsonElement jsonElement : dropList) {
                JsonObject object = jsonElement.getAsJsonObject();
                String itemid = GsonHelper.getAsString((JsonObject)object, (String)"item");
                Item item = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(itemid));
                int count = GsonHelper.getAsInt((JsonObject)object, (String)"count", (int)1);
                drops.add(new ItemStack((ItemLike)item, count));
            }
            builder.setDrops(drops);
        }
        return builder.build();
    }

    private static <T> T getRequiredEntry(Registry<T> registry, String id) {
        T entry = registry.getOptional(new ResourceLocation(id)).orElse(null);
        if (entry == null) {
            throw new IllegalArgumentException("Unknown id " + id + " for " + registry);
        }
        return entry;
    }

    @Nullable
    public EntropyRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int dropSize;
        int appliersSize;
        Fluid fluid;
        int i;
        int matcherSize;
        EntropyRecipeBuilder builder = new EntropyRecipeBuilder();
        builder.setId(recipeId);
        builder.setMode((EntropyMode)buffer.readEnum(EntropyMode.class));
        if (buffer.readBoolean()) {
            Block inputBlock = (Block)BuiltInRegistries.BLOCK.byId(buffer.readVarInt());
            builder.setInputBlock(inputBlock);
            matcherSize = buffer.readInt();
            for (i = 0; i < matcherSize; ++i) {
                builder.addBlockStateMatcher(StateMatcher.read(inputBlock.getStateDefinition(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            fluid = (Fluid)BuiltInRegistries.FLUID.byId(buffer.readVarInt());
            builder.setInputFluid(fluid);
            matcherSize = buffer.readInt();
            for (i = 0; i < matcherSize; ++i) {
                builder.addFluidStateMatcher(StateMatcher.read(fluid.getStateDefinition(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            Block block = (Block)BuiltInRegistries.BLOCK.byId(buffer.readVarInt());
            builder.setOutputBlock(block);
            builder.setOutputBlockKeep(buffer.readBoolean());
            appliersSize = buffer.readInt();
            for (i = 0; i < appliersSize; ++i) {
                builder.addBlockStateAppliers(StateApplier.readFromPacket(block.getStateDefinition(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            fluid = (Fluid)BuiltInRegistries.FLUID.byId(buffer.readVarInt());
            builder.setOutputFluid(fluid);
            builder.setOutputFluidKeep(buffer.readBoolean());
            appliersSize = buffer.readInt();
            for (i = 0; i < appliersSize; ++i) {
                builder.addFluidStateAppliers(StateApplier.readFromPacket(fluid.getStateDefinition(), buffer));
            }
        }
        if ((dropSize = buffer.readInt()) > 0) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(dropSize);
            for (i = 0; i < dropSize; ++i) {
                drops.add(buffer.readItem());
            }
            builder.setDrops(drops);
        }
        return builder.build();
    }

    public void toNetwork(FriendlyByteBuf buffer, EntropyRecipe recipe) {
        List<StateApplier<?>> appliers;
        buffer.writeEnum((Enum)recipe.getMode());
        buffer.writeBoolean(recipe.getInputBlock() != null);
        if (recipe.getInputBlock() != null) {
            buffer.writeVarInt(BuiltInRegistries.BLOCK.getId((Object)recipe.getInputBlock()));
            List<StateMatcher> inputBlockMatchers = recipe.getInputBlockMatchers();
            buffer.writeInt(inputBlockMatchers.size());
            for (StateMatcher stateMatcher : inputBlockMatchers) {
                stateMatcher.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getInputFluid() != null);
        if (recipe.getInputFluid() != null) {
            buffer.writeVarInt(BuiltInRegistries.FLUID.getId((Object)recipe.getInputFluid()));
            List<StateMatcher> inputFluidMatchers = recipe.getInputFluidMatchers();
            buffer.writeInt(inputFluidMatchers.size());
            for (StateMatcher stateMatcher : inputFluidMatchers) {
                stateMatcher.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getOutputBlock() != null);
        if (recipe.getOutputBlock() != null) {
            buffer.writeVarInt(BuiltInRegistries.BLOCK.getId((Object)recipe.getOutputBlock()));
            buffer.writeBoolean(recipe.getOutputBlockKeep());
            appliers = recipe.getOutputBlockStateAppliers();
            buffer.writeInt(appliers.size());
            for (StateApplier stateApplier : appliers) {
                stateApplier.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getOutputFluid() != null);
        if (recipe.getOutputFluid() != null) {
            buffer.writeVarInt(BuiltInRegistries.FLUID.getId((Object)recipe.getOutputFluid()));
            buffer.writeBoolean(recipe.getOutputFluidKeep());
            appliers = recipe.getOutputFluidStateAppliers();
            buffer.writeInt(appliers.size());
            for (StateApplier stateApplier : appliers) {
                stateApplier.writeToPacket(buffer);
            }
        }
        buffer.writeInt(recipe.getDrops().size());
        for (ItemStack itemStack : recipe.getDrops()) {
            buffer.writeItem(itemStack);
        }
    }

    private static void parseStateMatchers(StateDefinition<?, ?> stateDefinition, JsonObject propertiesContainer, Consumer<StateMatcher> consumer) {
        JsonObject properties = GsonHelper.getAsJsonObject((JsonObject)propertiesContainer, (String)"properties", (JsonObject)new JsonObject());
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value == null) {
                return;
            }
            if (value.isJsonPrimitive()) {
                consumer.accept(SingleValueMatcher.create(stateDefinition, key, value.getAsString()));
            } else if (value.isJsonArray()) {
                JsonArray array = value.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (JsonElement e : array) {
                    list.add(e.getAsString());
                }
                consumer.accept(MultipleValuesMatcher.create(stateDefinition, key, list));
            } else if (value.isJsonObject() && value.getAsJsonObject().has("min") && value.getAsJsonObject().has("max")) {
                String min = value.getAsJsonObject().get("min").getAsString();
                String max = value.getAsJsonObject().get("max").getAsString();
                consumer.accept(RangeValueMatcher.create(stateDefinition, key, min, max));
            } else {
                throw new IllegalArgumentException("Invalid matcher: " + value);
            }
        });
    }

    private static void parseStateAppliers(StateDefinition<?, ?> stateDefinition, JsonObject propertiesContainer, Consumer<StateApplier<?>> consumer) {
        JsonObject properties = GsonHelper.getAsJsonObject((JsonObject)propertiesContainer, (String)"properties", (JsonObject)new JsonObject());
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(StateApplier.create(stateDefinition, key, value));
        });
    }

    public void toJson(EntropyRecipe recipe, JsonObject json) {
        json.addProperty("mode", recipe.getMode().name().toLowerCase(Locale.ROOT));
        json.add("input", (JsonElement)this.serializeInput(recipe));
        json.add("output", this.serializeOutput(recipe));
    }

    private JsonObject serializeInput(EntropyRecipe recipe) {
        JsonObject input = new JsonObject();
        if (recipe.getInputBlock() != null) {
            JsonObject jsonBlock = new JsonObject();
            jsonBlock.addProperty("id", BuiltInRegistries.BLOCK.getKey((Object)recipe.getInputBlock()).toString());
            this.serializeStateMatchers(recipe.getInputBlockMatchers(), jsonBlock);
            input.add("block", (JsonElement)jsonBlock);
        }
        if (recipe.getInputFluid() != null) {
            JsonObject jsonFluid = new JsonObject();
            jsonFluid.addProperty("id", BuiltInRegistries.FLUID.getKey((Object)recipe.getInputFluid()).toString());
            this.serializeStateMatchers(recipe.getInputFluidMatchers(), jsonFluid);
            input.add("fluid", (JsonElement)jsonFluid);
        }
        return input;
    }

    private JsonElement serializeOutput(EntropyRecipe recipe) {
        JsonObject output = new JsonObject();
        if (recipe.getOutputBlock() != null) {
            JsonObject jsonBlock = new JsonObject();
            jsonBlock.addProperty("id", BuiltInRegistries.BLOCK.getKey((Object)recipe.getOutputBlock()).toString());
            if (recipe.getOutputBlockKeep()) {
                jsonBlock.addProperty("keep", Boolean.valueOf(true));
            }
            this.serializeStateAppliers(recipe.getOutputBlockStateAppliers(), jsonBlock);
            output.add("block", (JsonElement)jsonBlock);
        }
        if (recipe.getOutputFluid() != null) {
            JsonObject jsonFluid = new JsonObject();
            jsonFluid.addProperty("id", BuiltInRegistries.FLUID.getKey((Object)recipe.getOutputFluid()).toString());
            if (recipe.getOutputFluidKeep()) {
                jsonFluid.addProperty("keep", Boolean.valueOf(true));
            }
            this.serializeStateAppliers(recipe.getOutputFluidStateAppliers(), jsonFluid);
            output.add("fluid", (JsonElement)jsonFluid);
        }
        if (!recipe.getDrops().isEmpty()) {
            JsonArray jsonDrops = new JsonArray();
            for (ItemStack drop : recipe.getDrops()) {
                JsonObject jsonDrop = new JsonObject();
                jsonDrop.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)drop.getItem()).toString());
                if (drop.getCount() > 1) {
                    jsonDrop.addProperty("count", (Number)drop.getCount());
                }
                jsonDrops.add((JsonElement)jsonDrop);
            }
            output.add("drops", (JsonElement)jsonDrops);
        }
        return output;
    }

    private void serializeStateMatchers(List<StateMatcher> matchers, JsonObject json) {
        if (matchers.isEmpty()) {
            return;
        }
        JsonObject properties = new JsonObject();
        for (StateMatcher matcher : matchers) {
            JsonPrimitive serializedMatcher;
            if (matcher instanceof SingleValueMatcher) {
                SingleValueMatcher singleMatcher = (SingleValueMatcher)matcher;
                serializedMatcher = new JsonPrimitive(singleMatcher.getValueName());
            } else if (matcher instanceof MultipleValuesMatcher) {
                MultipleValuesMatcher multiMatcher = (MultipleValuesMatcher)matcher;
                JsonArray values = new JsonArray();
                for (String valueName : multiMatcher.getValueNames()) {
                    values.add(valueName);
                }
                serializedMatcher = values;
            } else if (matcher instanceof RangeValueMatcher) {
                RangeValueMatcher rangeMatcher = (RangeValueMatcher)matcher;
                JsonObject range = new JsonObject();
                range.addProperty("min", rangeMatcher.getMinValueName());
                range.addProperty("max", rangeMatcher.getMaxValueName());
                serializedMatcher = range;
            } else {
                throw new IllegalStateException("Don't know how to serialize state matcher " + matcher);
            }
            String propertyName = matcher.getProperty().getName();
            properties.add(propertyName, (JsonElement)serializedMatcher);
        }
        json.add("properties", (JsonElement)properties);
    }

    private void serializeStateAppliers(List<StateApplier<?>> appliers, JsonObject json) {
        if (appliers.isEmpty()) {
            return;
        }
        JsonObject properties = new JsonObject();
        for (StateApplier<?> applier : appliers) {
            Property<?> property = applier.getProperty();
            properties.addProperty(property.getName(), applier.getValueName());
        }
        json.add("properties", (JsonElement)properties);
    }
}

