/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.inventories.InternalInventory;
import appeng.crafting.CraftingEvent;
import appeng.helpers.Inventories;
import appeng.menu.slot.AppEngSlot;
import appeng.util.inv.AppEngInternalInventory;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class AppEngCraftingSlot
extends AppEngSlot {
    private final InternalInventory craftingGrid;
    private final Player player;
    private int amountCrafted;

    public AppEngCraftingSlot(Player player, InternalInventory craftingGrid) {
        super(new AppEngInternalInventory(1), 0);
        this.player = player;
        this.craftingGrid = craftingGrid;
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    protected void onQuickCraft(ItemStack par1ItemStack, int par2) {
        this.amountCrafted += par2;
        this.checkTakeAchievements(par1ItemStack);
    }

    protected void checkTakeAchievements(ItemStack par1ItemStack) {
        par1ItemStack.onCraftedBy(this.player.level(), this.player, this.amountCrafted);
        this.amountCrafted = 0;
    }

    public void onTake(Player playerIn, ItemStack stack) {
        CraftingEvent.fireCraftingEvent(playerIn, stack, this.craftingGrid.toContainer());
        this.amountCrafted += stack.getCount();
        this.checkTakeAchievements(stack);
        ForgeHooks.setCraftingPlayer((Player)playerIn);
        TransientCraftingContainer ic = new TransientCraftingContainer((AbstractContainerMenu)this.getMenu(), 3, 3);
        for (int x = 0; x < this.craftingGrid.size(); ++x) {
            ic.setItem(x, this.craftingGrid.getStackInSlot(x));
        }
        NonNullList<ItemStack> aitemstack = this.getRemainingItems((CraftingContainer)ic, playerIn.level());
        Inventories.copy((CraftingContainer)ic, this.craftingGrid, false);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack1 = this.craftingGrid.getStackInSlot(i);
            ItemStack itemstack2 = (ItemStack)aitemstack.get(i);
            if (!itemstack1.isEmpty()) {
                this.craftingGrid.extractItem(i, 1, false);
            }
            if (itemstack2.isEmpty()) continue;
            if (this.craftingGrid.getStackInSlot(i).isEmpty()) {
                this.craftingGrid.setItemDirect(i, itemstack2);
                continue;
            }
            if (this.player.getInventory().add(itemstack2)) continue;
            this.player.drop(itemstack2, false);
        }
    }

    public void setDisplayedCraftingOutput(ItemStack stack) {
        this.getInventory().setItemDirect(0, stack);
    }

    @Override
    public ItemStack remove(int par1) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(par1, this.getItem().getCount());
        }
        return super.remove(par1);
    }

    protected NonNullList<ItemStack> getRemainingItems(CraftingContainer ic, Level level) {
        return level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)ic, level).map(iCraftingRecipe -> iCraftingRecipe.getRemainingItems((Container)ic)).orElse(NonNullList.withSize((int)9, (Object)ItemStack.EMPTY));
    }
}

