/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.stacks.AEKey;
import java.util.Comparator;
import net.minecraft.network.FriendlyByteBuf;

public record CraftingPlanSummaryEntry(AEKey what, long missingAmount, long storedAmount, long craftAmount, long availableAmount) implements Comparable<CraftingPlanSummaryEntry>
{
    private static final Comparator<CraftingPlanSummaryEntry> COMPARATOR = Comparator.comparing(CraftingPlanSummaryEntry::missingAmount).thenComparing(CraftingPlanSummaryEntry::craftAmount).thenComparing(CraftingPlanSummaryEntry::storedAmount).thenComparing(CraftingPlanSummaryEntry::availableAmount).reversed();

    @Override
    public int compareTo(CraftingPlanSummaryEntry o) {
        return COMPARATOR.compare(this, o);
    }

    public void write(FriendlyByteBuf buffer) {
        AEKey.writeKey(buffer, this.what);
        buffer.writeVarLong(this.missingAmount);
        buffer.writeVarLong(this.storedAmount);
        buffer.writeVarLong(this.craftAmount);
        buffer.writeVarLong(this.availableAmount);
    }

    public static CraftingPlanSummaryEntry read(FriendlyByteBuf buffer) {
        AEKey what = AEKey.readKey(buffer);
        long missingAmount = buffer.readVarLong();
        long storedAmount = buffer.readVarLong();
        long craftAmount = buffer.readVarLong();
        long availableAmount = buffer.readVarLong();
        return new CraftingPlanSummaryEntry(what, missingAmount, storedAmount, craftAmount, availableAmount);
    }
}

