/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.block.networking.CableBusBlock;
import appeng.block.paint.PaintSplotchesBlock;
import appeng.blockentity.misc.PaintSplotchesBlockEntity;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.misc.PaintBallItem;
import appeng.items.storage.StorageTier;
import appeng.items.tools.powered.BlockRecolorer;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.cells.BasicCellHandler;
import appeng.me.cells.BasicCellInventory;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.PlayerSource;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ColorApplicatorItem
extends AEBasePoweredItem
implements IBasicCellItem,
IBlockTool,
IMouseWheelItem {
    private static final double POWER_PER_USE = 100.0;
    private static final Map<TagKey<Item>, AEColor> TAG_TO_COLOR = AEColor.VALID_COLORS.stream().collect(Collectors.toMap(aeColor -> ConventionTags.dye(aeColor.dye), Function.identity()));
    private static final BiMap<DyeColor, Item> VANILLA_DYES = EnumHashBiMap.create(DyeColor.class);
    private static final String TAG_COLOR = "color";

    public ColorApplicatorItem(Item.Properties props) {
        super(AEConfig.instance().getColorApplicatorBattery(), props);
    }

    @Override
    public double getChargeRate(ItemStack stack) {
        return 80.0 + 80.0 * (double)Upgrades.getEnergyCardMultiplier(this.getUpgrades(stack));
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack is = context.getItemInHand();
        Direction side = context.getClickedFace();
        Player p = context.getPlayer();
        if (p == null && level instanceof ServerLevel) {
            p = Platform.getFakePlayer((ServerLevel)level, null);
        }
        Block blk = level.getBlockState(pos).getBlock();
        ItemStack paintBall = this.getColor(is);
        AEItemKey paintBallKey = AEItemKey.of(paintBall);
        PlayerSource source = new PlayerSource(p);
        StorageCell inv = StorageCells.getCellInventory(is, null);
        if (inv != null) {
            long extracted = inv.extract(paintBallKey, 1L, Actionable.SIMULATE, source);
            if (extracted > 0L) {
                paintBall = paintBall.copy();
                paintBall.setCount(1);
            } else {
                paintBall = ItemStack.EMPTY;
            }
            if (p != null && !Platform.hasPermissions(new DimensionalBlockPos(level, pos), p)) {
                return InteractionResult.FAIL;
            }
            if (!paintBall.isEmpty()) {
                AEColor color;
                if (paintBall.getItem() instanceof SnowballItem) {
                    BlockEntity blockEntity;
                    if (p != null && (blockEntity = level.getBlockEntity(pos)) instanceof IColorableBlockEntity) {
                        IColorableBlockEntity colorableBlockEntity = (IColorableBlockEntity)blockEntity;
                        if (this.getAECurrentPower(is) > 100.0 && colorableBlockEntity.getColor() != AEColor.TRANSPARENT && colorableBlockEntity.recolourBlock(side, AEColor.TRANSPARENT, p)) {
                            this.consumeItem(is, paintBallKey, false);
                            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
                        }
                    }
                    Block testBlk = level.getBlockState(pos.relative(side)).getBlock();
                    BlockEntity painted = level.getBlockEntity(pos.relative(side));
                    if (this.getAECurrentPower(is) > 100.0 && testBlk instanceof PaintSplotchesBlock && painted instanceof PaintSplotchesBlockEntity) {
                        this.consumeItem(is, paintBallKey, false);
                        ((PaintSplotchesBlockEntity)painted).cleanSide(side.getOpposite());
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
                    }
                }
                if ((color = this.getColorFromItem(paintBall)) != null && this.getAECurrentPower(is) > 100.0 && this.recolourBlock(blk, side, level, pos, color, p)) {
                    this.consumeItem(is, paintBallKey, false);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
            }
        }
        if (p != null && InteractionUtil.isInAlternateUseMode(p)) {
            this.cycleColors(is, paintBall, 1);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult interactLivingEntity(ItemStack is, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Sheep sheep;
        ItemStack paintBall = this.getColor(is);
        AEColor paintBallColor = this.getColorFromItem(paintBall);
        if (paintBallColor != null && interactionTarget instanceof Sheep && (sheep = (Sheep)interactionTarget).isAlive() && !sheep.isSheared() && sheep.getColor() != paintBallColor.dye) {
            if (!player.level().isClientSide && this.getAECurrentPower(is) > 100.0) {
                sheep.setColor(paintBallColor.dye);
                sheep.level().playSound(player, (Entity)sheep, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.consumeItem(is, AEItemKey.of(paintBall), false);
            }
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public Component getName(ItemStack is) {
        MutableComponent extra = GuiText.Empty.text();
        AEColor selected = this.getActiveColor(is);
        if (selected != null && Platform.isClient()) {
            extra = Component.translatable((String)selected.translationKey);
        }
        return super.getName(is).copy().append(" - ").append((Component)extra);
    }

    public AEColor getActiveColor(ItemStack tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    public boolean consumeColor(ItemStack applicator, AEColor color, boolean simulate) {
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return false;
        }
        KeyCounter availableItems = inv.getAvailableStacks();
        AEItemKey paintItem = null;
        for (AEKey what : availableItems.keySet()) {
            AEItemKey itemKey;
            if (!(what instanceof AEItemKey) || this.getColorFromItem((itemKey = (AEItemKey)what).getItem()) != color) continue;
            paintItem = itemKey;
            break;
        }
        if (paintItem != null) {
            return this.consumeItem(applicator, paintItem, simulate);
        }
        return false;
    }

    public boolean consumeItem(ItemStack applicator, AEItemKey paintItem, boolean simulate) {
        boolean success;
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return false;
        }
        Actionable mode = simulate ? Actionable.SIMULATE : Actionable.MODULATE;
        boolean bl = success = inv.extract(paintItem, 1L, mode, new BaseActionSource()) >= 1L && this.extractAEPower(applicator, 100.0, mode) >= 100.0;
        if (success && !simulate && paintItem.matches(this.getColor(applicator)) && inv.getAvailableStacks().get(paintItem) == 0L) {
            this.setColor(applicator, ItemStack.EMPTY);
        }
        return success;
    }

    private AEColor getColorFromItem(ItemStack paintBall) {
        if (paintBall.isEmpty()) {
            return null;
        }
        return this.getColorFromItem(paintBall.getItem());
    }

    private AEColor getColorFromItem(Item paintBall) {
        if (paintBall instanceof SnowballItem) {
            return AEColor.TRANSPARENT;
        }
        if (paintBall instanceof PaintBallItem) {
            PaintBallItem ipb = (PaintBallItem)paintBall;
            return ipb.getColor();
        }
        DyeColor vanillaDye = (DyeColor)VANILLA_DYES.inverse().get((Object)paintBall);
        if (vanillaDye != null) {
            return AEColor.fromDye(vanillaDye);
        }
        for (Map.Entry<TagKey<Item>, AEColor> entry : TAG_TO_COLOR.entrySet()) {
            if (!paintBall.builtInRegistryHolder().is(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public ItemStack getColor(ItemStack is) {
        CompoundTag color;
        ItemStack oldColor;
        CompoundTag c = is.getTag();
        if (c != null && c.contains(TAG_COLOR) && !(oldColor = ItemStack.of((CompoundTag)(color = c.getCompound(TAG_COLOR)))).isEmpty()) {
            return oldColor;
        }
        return this.findNextColor(is, ItemStack.EMPTY, 0);
    }

    private ItemStack findNextColor(ItemStack is, ItemStack anchor, int scrollOffset) {
        ItemStack newColor = ItemStack.EMPTY;
        StorageCell inv = StorageCells.getCellInventory(is, null);
        if (inv != null) {
            KeyCounter itemList = inv.getAvailableStacks();
            if (anchor.isEmpty()) {
                AEItemKey firstItem = itemList.getFirstKey(AEItemKey.class);
                if (firstItem != null) {
                    newColor = firstItem.toStack();
                }
            } else {
                LinkedList<AEItemKey> list = new LinkedList<AEItemKey>();
                for (Object2LongMap.Entry<AEKey> i : itemList) {
                    Object object = i.getKey();
                    if (!(object instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)object;
                    list.add(itemKey);
                }
                if (list.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                list.sort(Comparator.comparingInt(a -> {
                    AEColor color = this.getColorFromItem(a.getItem());
                    return color != null ? color.ordinal() : Integer.MAX_VALUE;
                }));
                AEItemKey where = (AEItemKey)list.getFirst();
                AEColor anchorColor = this.getColorFromItem(anchor);
                for (int cycles = 1 + list.size(); cycles > 0 && this.getColorFromItem(where.getItem()) != anchorColor; --cycles) {
                    list.addLast((AEItemKey)list.removeFirst());
                    where = (AEItemKey)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((AEItemKey)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((AEItemKey)list.removeLast());
                }
                return ((AEItemKey)list.get(0)).toStack();
            }
        }
        if (!newColor.isEmpty()) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    private void setColor(ItemStack is, ItemStack newColor) {
        CompoundTag data = is.getOrCreateTag();
        if (newColor.isEmpty()) {
            data.remove(TAG_COLOR);
        } else {
            CompoundTag color = new CompoundTag();
            newColor.save(color);
            data.put(TAG_COLOR, (Tag)color);
        }
    }

    private boolean recolourBlock(Block blk, Direction side, Level level, BlockPos pos, AEColor newColor, @Nullable Player p) {
        IColorableBlockEntity ct;
        BlockEntity be;
        BlockState state = level.getBlockState(pos);
        Block recolored = BlockRecolorer.recolor(blk, newColor);
        if (recolored != blk) {
            BlockState newState = recolored.defaultBlockState();
            for (Property prop : newState.getProperties()) {
                newState = ColorApplicatorItem.copyProp(state, newState, prop);
            }
            return level.setBlockAndUpdate(pos, newState);
        }
        if (blk instanceof CableBusBlock) {
            CableBusBlock cableBusBlock = (CableBusBlock)blk;
            if (p != null) {
                return cableBusBlock.recolorBlock((BlockGetter)level, pos, side, newColor.dye, p);
            }
        }
        if ((be = level.getBlockEntity(pos)) instanceof IColorableBlockEntity && (ct = (IColorableBlockEntity)be).getColor() != newColor) {
            ct.recolourBlock(side, newColor, p);
            return true;
        }
        return false;
    }

    private static <T extends Comparable<T>> BlockState copyProp(BlockState oldState, BlockState newState, Property<T> prop) {
        if (newState.hasProperty(prop)) {
            return (BlockState)newState.setValue(prop, oldState.getValue(prop));
        }
        return newState;
    }

    public void cycleColors(ItemStack is, ItemStack paintBall, int i) {
        if (paintBall.isEmpty()) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.appendHoverText(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return this.getCellTooltipImage(stack);
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return StorageTier.SIZE_4K.bytes() / 2;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return StorageTier.SIZE_4K.bytes() / 128;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, AEKey requestedAddition) {
        if (requestedAddition instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)requestedAddition;
            return this.getColorFromItem(itemKey.getItem()) == null;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public AEKeyType getKeyType() {
        return AEKeyType.items();
    }

    @Override
    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem(is, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, 1 + Upgrades.getEnergyCardMultiplier(upgrades) * 8);
    }

    @Override
    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create(AEItemKey.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.getOrCreateTag().getString("FuzzyMode");
        if (fz.isEmpty()) {
            return FuzzyMode.IGNORE_ALL;
        }
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.getOrCreateTag().putString("FuzzyMode", fzMode.name());
    }

    @Override
    public void onWheel(ItemStack is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }

    @Override
    public void addToMainCreativeTab(CreativeModeTab.Output output) {
        super.addToMainCreativeTab(output);
        output.accept(ColorApplicatorItem.createFullColorApplicator());
    }

    public static ItemStack createFullColorApplicator() {
        ColorApplicatorItem item = AEItems.COLOR_APPLICATOR.asItem();
        ItemStack applicator = new ItemStack((ItemLike)item);
        BasicCellInventory dyeStorage = BasicCellHandler.INSTANCE.getCellInventory(applicator, null);
        for (Item dyeItem : VANILLA_DYES.values()) {
            dyeStorage.insert(AEItemKey.of((ItemLike)dyeItem), 128L, Actionable.MODULATE, new BaseActionSource());
        }
        dyeStorage.insert(AEItemKey.of((ItemLike)Items.SNOWBALL), 128L, Actionable.MODULATE, new BaseActionSource());
        IUpgradeInventory upgrades = item.getUpgrades(applicator);
        upgrades.addItems(AEItems.ENERGY_CARD.stack());
        upgrades.addItems(AEItems.ENERGY_CARD.stack());
        item.injectAEPower(applicator, item.getAEMaxPower(applicator), Actionable.MODULATE);
        return applicator;
    }

    public void setActiveColor(ItemStack applicator, @Nullable AEColor color) {
        if (color == null) {
            this.setColor(applicator, ItemStack.EMPTY);
            return;
        }
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return;
        }
        for (Object2LongMap.Entry<AEKey> entry : inv.getAvailableStacks()) {
            AEItemKey itemKey;
            Object object = entry.getKey();
            if (!(object instanceof AEItemKey) || this.getColorFromItem((itemKey = (AEItemKey)object).getItem()) != color) continue;
            this.setColor(applicator, itemKey.toStack());
            return;
        }
    }

    static {
        VANILLA_DYES.put((Object)DyeColor.WHITE, (Object)Items.WHITE_DYE);
        VANILLA_DYES.put((Object)DyeColor.ORANGE, (Object)Items.ORANGE_DYE);
        VANILLA_DYES.put((Object)DyeColor.MAGENTA, (Object)Items.MAGENTA_DYE);
        VANILLA_DYES.put((Object)DyeColor.LIGHT_BLUE, (Object)Items.LIGHT_BLUE_DYE);
        VANILLA_DYES.put((Object)DyeColor.YELLOW, (Object)Items.YELLOW_DYE);
        VANILLA_DYES.put((Object)DyeColor.LIME, (Object)Items.LIME_DYE);
        VANILLA_DYES.put((Object)DyeColor.PINK, (Object)Items.PINK_DYE);
        VANILLA_DYES.put((Object)DyeColor.GRAY, (Object)Items.GRAY_DYE);
        VANILLA_DYES.put((Object)DyeColor.LIGHT_GRAY, (Object)Items.LIGHT_GRAY_DYE);
        VANILLA_DYES.put((Object)DyeColor.CYAN, (Object)Items.CYAN_DYE);
        VANILLA_DYES.put((Object)DyeColor.PURPLE, (Object)Items.PURPLE_DYE);
        VANILLA_DYES.put((Object)DyeColor.BLUE, (Object)Items.BLUE_DYE);
        VANILLA_DYES.put((Object)DyeColor.BROWN, (Object)Items.BROWN_DYE);
        VANILLA_DYES.put((Object)DyeColor.GREEN, (Object)Items.GREEN_DYE);
        VANILLA_DYES.put((Object)DyeColor.RED, (Object)Items.RED_DYE);
        VANILLA_DYES.put((Object)DyeColor.BLACK, (Object)Items.BLACK_DYE);
    }
}

