/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.contents;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.util.IConfigManager;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.menu.ISubMenu;
import appeng.util.ConfigManager;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PortableCellMenuHost
extends ItemMenuHost
implements IPortableTerminal {
    private final BiConsumer<Player, ISubMenu> returnMainMenu;
    private final MEStorage cellStorage;
    private final AbstractPortableCell item;

    public PortableCellMenuHost(Player player, @Nullable Integer slot, AbstractPortableCell item, ItemStack itemStack, BiConsumer<Player, ISubMenu> returnMainMenu) {
        super(player, slot, itemStack);
        Preconditions.checkArgument((itemStack.getItem() == item ? 1 : 0) != 0, (Object)"Stack doesn't match item");
        this.returnMainMenu = returnMainMenu;
        this.cellStorage = StorageCells.getCellInventory(itemStack, null);
        Objects.requireNonNull(this.cellStorage, "Portable cell doesn't expose a cell inventory.");
        this.item = item;
    }

    @Override
    public boolean onBroadcastChanges(AbstractContainerMenu menu) {
        return this.ensureItemStillInSlot() && this.drainPower();
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.item.getAECurrentPower(this.getItemStack())));
        }
        return usePowerMultiplier.divide(this.item.extractAEPower(this.getItemStack(), amt, Actionable.MODULATE));
    }

    @Override
    public MEStorage getInventory() {
        return this.cellStorage;
    }

    @Override
    public IConfigManager getConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName) -> manager.writeToNBT(this.getItemStack().getOrCreateTag()));
        out.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        out.readFromNBT(this.getItemStack().getOrCreateTag().copy());
        return out;
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        this.returnMainMenu.accept(player, subMenu);
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return this.getItemStack();
    }

    @Override
    public String getCloseHotkey() {
        AbstractPortableCell abstractPortableCell = this.item;
        if (abstractPortableCell instanceof IBasicCellItem) {
            IBasicCellItem cellItem = (IBasicCellItem)((Object)abstractPortableCell);
            if (cellItem.getKeyType().equals(AEKeyType.items())) {
                return "portable_item_cell";
            }
            if (cellItem.getKeyType().equals(AEKeyType.fluids())) {
                return "portable_fluid_cell";
            }
        }
        return null;
    }
}

